/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.containers;

import java.io.File;
import java.util.Objects;

public final class TextFileDataContainer {
    private final String[] text;
    private final boolean fileEndedByNextLine;
    private final File file;
    private boolean autoFlush = true;
    private int nextStringIndex;

    public TextFileDataContainer(TextFileDataContainer item, int stringIndex) {
        this(item.file, item.text, item.fileEndedByNextLine, stringIndex);
    }

    public TextFileDataContainer(File currentFile, String[] text, boolean fileEndedByNextLine, int stringIndex) {
        Objects.requireNonNull(currentFile, "File is null");
        Objects.requireNonNull(text, "Text is null");
        this.file = currentFile;
        this.text = text;
        this.setNextStringIndex(stringIndex);
        this.fileEndedByNextLine = fileEndedByNextLine;
    }

    public void disableAutoFlush() {
        this.autoFlush = false;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public String[] getText() {
        return (String[])this.text.clone();
    }

    public File getFile() {
        return this.file;
    }

    public void reset() {
        this.nextStringIndex = 0;
    }

    public boolean isPresentedNextLineOnReadString() {
        return this.nextStringIndex < this.text.length || this.fileEndedByNextLine;
    }

    public String nextLine() {
        if (this.nextStringIndex >= this.text.length) {
            return null;
        }
        return this.text[this.nextStringIndex++];
    }

    public int getLastReadStringIndex() {
        return this.nextStringIndex - 1;
    }

    public int getNextStringIndex() {
        return this.nextStringIndex;
    }

    public void setNextStringIndex(int index) {
        if (index < 0 || index >= this.text.length) {
            throw new IndexOutOfBoundsException("String index out of bound [" + index + ']');
        }
        this.nextStringIndex = index;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TextFileDataContainer) {
            TextFileDataContainer thatItem = (TextFileDataContainer)that;
            return this.file.equals(thatItem.file) && this.nextStringIndex == thatItem.nextStringIndex;
        }
        return false;
    }
}

