/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.expression.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class EnvironmentVariableProcessor
implements SpecialVariableProcessor {
    private static final String PREFIX = "env.";
    private final Map<String, Value> environmentVars;

    public EnvironmentVariableProcessor() {
        HashMap<String, Value> env = new HashMap<String, Value>();
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            env.put(PREFIX + key.toLowerCase(Locale.ENGLISH).replace(' ', '_'), Value.valueOf(properties.getProperty(key)));
        }
        this.environmentVars = Collections.unmodifiableMap(env);
    }

    @Override
    public String[] getVariableNames() {
        return this.environmentVars.keySet().toArray(new String[0]);
    }

    @Override
    public Value getVariable(String varName, PreprocessorContext context) {
        Value result = this.environmentVars.get(varName);
        if (result == null) {
            throw context.makeException("Can't find in environment: " + varName, null);
        }
        return result;
    }

    @Override
    public void setVariable(String varName, Value value, PreprocessorContext context) {
        throw context.makeException("Illegal change of environment record '" + varName + "'. Environment records accessible only for reading!", null);
    }
}

