/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.removers.JavaCommentsRemover;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.jcp.utils.ResetablePrinter;
import hidden.jcp.org.apache.commons.io.FileUtils;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PreprocessingState {
    public static final FilePositionInfo[] EMPTY_STACK = new FilePositionInfo[0];
    public static final int MAX_WRITE_BUFFER_SIZE = 65536;
    private final Charset globalInCharacterEncoding;
    private final Charset globalOutCharacterEncoding;
    private final TextFileDataContainer rootReference;
    private final FileInfoContainer rootFileInfo;
    private final LinkedList<TextFileDataContainer> whileStack = new LinkedList();
    private final LinkedList<TextFileDataContainer> ifStack = new LinkedList();
    private final LinkedList<TextFileDataContainer> includeStack = new LinkedList();
    private final LinkedList<ExcludeIfInfo> deferredExcludeStack = new LinkedList();
    private final ResetablePrinter prefixPrinter = new ResetablePrinter(1024);
    private final ResetablePrinter postfixPrinter = new ResetablePrinter(65536);
    private final ResetablePrinter normalPrinter = new ResetablePrinter(1024);
    private final boolean overrideOnlyIfContentChanged;
    private final EnumSet<PreprocessingFlag> preprocessingFlags = EnumSet.noneOf(PreprocessingFlag.class);
    private final PreprocessorContext context;
    private final boolean fake;
    private ResetablePrinter currentPrinter;
    private TextFileDataContainer activeIf;
    private TextFileDataContainer activeWhile;
    private String lastReadString;
    private boolean globalPhase;

    PreprocessingState(PreprocessorContext context, Charset inEncoding, Charset outEncoding) {
        this.fake = true;
        this.globalInCharacterEncoding = Objects.requireNonNull(inEncoding);
        this.globalOutCharacterEncoding = Objects.requireNonNull(outEncoding);
        this.rootReference = null;
        this.lastReadString = "";
        this.rootFileInfo = new FileInfoContainer(new File("global"), "global", true);
        this.overrideOnlyIfContentChanged = true;
        this.context = context;
        this.init();
    }

    PreprocessingState(PreprocessorContext context, FileInfoContainer rootFile, Charset inEncoding, Charset outEncoding, boolean overrideOnlyIfContentChanged) throws IOException {
        this.fake = false;
        this.context = context;
        this.overrideOnlyIfContentChanged = overrideOnlyIfContentChanged;
        this.globalInCharacterEncoding = Objects.requireNonNull(inEncoding);
        this.globalOutCharacterEncoding = Objects.requireNonNull(outEncoding);
        this.rootFileInfo = Objects.requireNonNull(rootFile, "The root file is null");
        this.init();
        this.rootReference = this.openFile(rootFile.getSourceFile());
    }

    PreprocessingState(PreprocessorContext context, FileInfoContainer rootFile, TextFileDataContainer rootContainer, Charset inEncoding, Charset outEncoding, boolean overrideOnlyIfContentChanged) {
        this.fake = false;
        this.context = context;
        this.globalInCharacterEncoding = Objects.requireNonNull(inEncoding);
        this.globalOutCharacterEncoding = Objects.requireNonNull(outEncoding);
        this.overrideOnlyIfContentChanged = overrideOnlyIfContentChanged;
        this.rootFileInfo = Objects.requireNonNull(rootFile, "The root file is null");
        this.init();
        this.rootReference = rootContainer;
        this.includeStack.push(rootContainer);
    }

    public boolean isGlobalPhase() {
        return this.globalPhase;
    }

    public void setGlobalPhase(boolean flag) {
        this.globalPhase = flag;
    }

    public String getLastReadString() {
        return this.lastReadString;
    }

    public void pushExcludeIfData(FileInfoContainer infoContainer, String excludeIfCondition, int stringIndex) {
        Objects.requireNonNull(infoContainer, "File info is null");
        Objects.requireNonNull(excludeIfCondition, "Condition is null");
        if (stringIndex < 0) {
            throw new IllegalArgumentException("Unexpected string index [" + stringIndex + ']');
        }
        this.deferredExcludeStack.push(new ExcludeIfInfo(infoContainer, excludeIfCondition, stringIndex));
    }

    public List<ExcludeIfInfo> popAllExcludeIfInfoData() {
        ArrayList<ExcludeIfInfo> result = new ArrayList<ExcludeIfInfo>(this.deferredExcludeStack);
        this.deferredExcludeStack.clear();
        return result;
    }

    public ExcludeIfInfo popExcludeIfData() {
        return this.deferredExcludeStack.pop();
    }

    public Set<PreprocessingFlag> getPreprocessingFlags() {
        return this.preprocessingFlags;
    }

    public ResetablePrinter getPrinter() throws IOException {
        return this.currentPrinter;
    }

    public void setPrinter(PrinterType type) {
        Objects.requireNonNull(type, "Type is null");
        switch (type) {
            case NORMAL: {
                this.currentPrinter = this.normalPrinter;
                break;
            }
            case POSTFIX: {
                this.currentPrinter = this.postfixPrinter;
                break;
            }
            case PREFIX: {
                this.currentPrinter = this.prefixPrinter;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type detected [" + type.name() + ']');
            }
        }
    }

    public TextFileDataContainer getRootTextContainer() {
        return this.rootReference;
    }

    public TextFileDataContainer openFile(File file) throws IOException {
        Objects.requireNonNull(file, "The file is null");
        AtomicBoolean endedByNextLineContainer = new AtomicBoolean();
        String[] texts = PreprocessorUtils.readWholeTextFileIntoArray(file, this.globalInCharacterEncoding, endedByNextLineContainer);
        TextFileDataContainer newContainer = new TextFileDataContainer(file, texts, endedByNextLineContainer.get(), 0);
        this.includeStack.push(newContainer);
        return newContainer;
    }

    public TextFileDataContainer peekFile() {
        return this.includeStack.peek();
    }

    public List<TextFileDataContainer> getCurrentIncludeStack() {
        return this.includeStack;
    }

    public FilePositionInfo[] makeIncludeStack() {
        if (this.fake) {
            return EMPTY_STACK;
        }
        FilePositionInfo[] stack = new FilePositionInfo[this.includeStack.size()];
        for (int i = 0; i < this.includeStack.size(); ++i) {
            TextFileDataContainer fileContainer = this.includeStack.get(i);
            stack[i] = new FilePositionInfo(fileContainer.getFile(), fileContainer.getLastReadStringIndex());
        }
        return stack;
    }

    public TextFileDataContainer getCurrentIncludeFileContainer() {
        return this.includeStack.isEmpty() ? null : this.includeStack.get(this.includeStack.size() - 1);
    }

    public TextFileDataContainer popTextContainer() {
        if (this.includeStack.isEmpty()) {
            throw new IllegalStateException("Include stack is empty");
        }
        return this.includeStack.pop();
    }

    public FileInfoContainer getRootFileInfo() {
        return this.rootFileInfo;
    }

    public boolean isIncludeStackEmpty() {
        return this.includeStack.isEmpty();
    }

    public boolean isOnlyRootOnStack() {
        return this.includeStack.size() == 1;
    }

    private TextFileDataContainer cloneTopTextDataContainer(boolean useLastReadStringIndex) {
        TextFileDataContainer topElement = this.includeStack.peek();
        return new TextFileDataContainer(topElement, useLastReadStringIndex ? topElement.getLastReadStringIndex() : topElement.getNextStringIndex());
    }

    public PreprocessingState popWhile() {
        TextFileDataContainer whileOnTop = this.whileStack.pop();
        if (whileOnTop == this.activeWhile) {
            this.preprocessingFlags.remove((Object)PreprocessingFlag.BREAK_COMMAND);
            this.activeWhile = this.whileStack.isEmpty() ? null : this.whileStack.peek();
        }
        return this;
    }

    public PreprocessingState pushWhile(boolean makeActive) {
        TextFileDataContainer whileRef = this.cloneTopTextDataContainer(true);
        this.whileStack.push(whileRef);
        if (makeActive) {
            this.activeWhile = whileRef;
        }
        return this;
    }

    public TextFileDataContainer peekWhile() {
        return this.whileStack.peek();
    }

    public boolean hasReadLineNextLineInEnd() {
        return this.includeStack.peek().isPresentedNextLineOnReadString();
    }

    public String nextLine() {
        String result;
        this.lastReadString = result = this.includeStack.peek().nextLine();
        return result;
    }

    public PreprocessingState goToString(int stringIndex) {
        this.includeStack.peek().setNextStringIndex(stringIndex);
        return this;
    }

    public PreprocessingState pushIf(boolean makeActive) {
        TextFileDataContainer ifRef = this.cloneTopTextDataContainer(true);
        this.ifStack.push(ifRef);
        if (makeActive) {
            this.activeIf = ifRef;
        }
        return this;
    }

    public void popAllIFUntilContainerWithFile(TextFileDataContainer container) {
        TextFileDataContainer top;
        File file = container.getFile();
        int stringIndex = container.getNextStringIndex();
        while (!this.ifStack.isEmpty() && (top = this.ifStack.peek()).getFile().equals(file) && top.getNextStringIndex() > stringIndex) {
            this.ifStack.pop();
        }
    }

    public PreprocessingState popIf() {
        TextFileDataContainer ifRef = this.ifStack.pop();
        if (ifRef == this.activeIf) {
            this.activeIf = this.ifStack.isEmpty() ? null : this.ifStack.peek();
        }
        return this;
    }

    public boolean isAtActiveWhile() {
        if (this.whileStack.isEmpty()) {
            return true;
        }
        return this.activeWhile == this.whileStack.peek();
    }

    public boolean isAtActiveIf() {
        if (this.ifStack.isEmpty()) {
            return true;
        }
        return this.ifStack.peek() == this.activeIf;
    }

    public boolean isDirectiveCanBeProcessedIgnoreBreak() {
        return this.isAtActiveIf() && this.isAtActiveWhile() && !this.preprocessingFlags.contains((Object)PreprocessingFlag.IF_CONDITION_FALSE);
    }

    public boolean isDirectiveCanBeProcessed() {
        return this.isDirectiveCanBeProcessedIgnoreBreak() && !this.preprocessingFlags.contains((Object)PreprocessingFlag.BREAK_COMMAND);
    }

    public TextFileDataContainer peekIf() {
        return this.ifStack.peek();
    }

    public boolean isIfStackEmpty() {
        return this.ifStack.isEmpty();
    }

    public boolean isWhileStackEmpty() {
        return this.whileStack.isEmpty();
    }

    private void init() {
        this.preprocessingFlags.clear();
        this.resetPrinters();
        this.setPrinter(PrinterType.NORMAL);
    }

    public void resetPrinters() {
        this.normalPrinter.reset();
        this.prefixPrinter.reset();
        this.postfixPrinter.reset();
        this.currentPrinter = this.normalPrinter;
    }

    public void saveBuffersToStreams(OutputStream prefix, OutputStream normal, OutputStream postfix) throws IOException {
        this.prefixPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(prefix, this.globalOutCharacterEncoding)));
        this.normalPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(normal, this.globalOutCharacterEncoding)));
        this.postfixPrinter.writeBufferTo(new BufferedWriter(new OutputStreamWriter(postfix, this.globalOutCharacterEncoding)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveBuffersToFile(File outFile, boolean keepComments) throws IOException {
        boolean wasSaved;
        OutputStreamWriter writer;
        block17: {
            File path = outFile.getParentFile();
            if (path != null && !path.exists() && !path.mkdirs()) {
                throw new IOException("Can't make directory [" + PreprocessorUtils.getFilePath(path) + ']');
            }
            writer = null;
            wasSaved = false;
            try {
                int totatBufferedChars = this.prefixPrinter.getSize() + this.normalPrinter.getSize() + this.postfixPrinter.getSize();
                int BUFFER_SIZE = Math.max(64, Math.min(totatBufferedChars << 1, 65536));
                if (this.overrideOnlyIfContentChanged) {
                    String content = this.writePrinterBuffers(new StringWriter(totatBufferedChars)).toString();
                    if (!keepComments) {
                        content = new JavaCommentsRemover(new StringReader(content), new StringWriter(totatBufferedChars)).process().toString();
                    }
                    boolean needWrite = true;
                    byte[] contentInBinaryForm = content.getBytes(this.globalOutCharacterEncoding);
                    if (outFile.isFile() && outFile.length() == (long)contentInBinaryForm.length) {
                        try (BufferedInputStream currentFileInputStream = new BufferedInputStream(new FileInputStream(outFile), Math.max(16384, (int)outFile.length()));){
                            needWrite = !IOUtils.contentEquals(currentFileInputStream, new ByteArrayInputStream(contentInBinaryForm));
                        }
                    }
                    if (needWrite) {
                        FileUtils.writeByteArrayToFile(outFile, contentInBinaryForm, false);
                        wasSaved = true;
                    } else {
                        this.context.logDebug("Ignore writing data for " + outFile + " because its content has not been changed");
                    }
                    break block17;
                }
                if (!keepComments) {
                    String joinedBufferContent = this.writePrinterBuffers(new StringWriter(totatBufferedChars)).toString();
                    writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false), BUFFER_SIZE), this.globalOutCharacterEncoding);
                    new JavaCommentsRemover(new StringReader(joinedBufferContent), writer).process();
                    wasSaved = true;
                    break block17;
                }
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile, false), BUFFER_SIZE), this.globalOutCharacterEncoding);
                this.writePrinterBuffers(writer);
                wasSaved = true;
            }
            catch (Throwable throwable) {
                com.igormaznitsa.jcp.utils.IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        com.igormaznitsa.jcp.utils.IOUtils.closeQuietly(writer);
        if (wasSaved) {
            PreprocessorUtils.findFirstActiveFileContainer(this.context).ifPresent(t -> t.getGeneratedResources().add(outFile));
            if (this.context.isKeepAttributes() && outFile.exists()) {
                PreprocessorUtils.copyFileAttributes(this.getRootFileInfo().getSourceFile(), outFile);
            }
        }
        return wasSaved;
    }

    public Writer writePrinterBuffers(Writer writer) throws IOException {
        if (!this.prefixPrinter.isEmpty()) {
            this.prefixPrinter.writeBufferTo(writer);
        }
        if (!this.normalPrinter.isEmpty()) {
            this.normalPrinter.writeBufferTo(writer);
        }
        if (!this.postfixPrinter.isEmpty()) {
            this.postfixPrinter.writeBufferTo(writer);
        }
        return writer;
    }

    public PreprocessorException makeException(String message, String causeString, Throwable cause) {
        return new PreprocessorException(message, causeString, this.makeIncludeStack(), cause);
    }

    public static class ExcludeIfInfo {
        private final FileInfoContainer fileInfoContainer;
        private final String condition;
        private final int stringIndex;

        public ExcludeIfInfo(FileInfoContainer fileInfoContainer, String condition, int stringIndex) {
            this.fileInfoContainer = fileInfoContainer;
            this.condition = condition.trim();
            this.stringIndex = stringIndex;
        }

        public int getStringIndex() {
            return this.stringIndex;
        }

        public FileInfoContainer getFileInfoContainer() {
            return this.fileInfoContainer;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static enum PrinterType {
        NORMAL,
        PREFIX,
        POSTFIX;

    }
}

