/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.EnvironmentVariableProcessor;
import com.igormaznitsa.jcp.context.JCPSpecialVariableProcessor;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.logger.SystemOutLogger;
import com.igormaznitsa.jcp.utils.GetUtils;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class PreprocessorContext {
    public static final List<String> DEFAULT_SOURCE_DIRECTORY = Collections.singletonList("." + File.separatorChar);
    public static final String DEFAULT_DEST_DIRECTORY = ".." + File.separatorChar + "preprocessed";
    public static final List<String> DEFAULT_PROCESSING_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("java", "txt", "htm", "html"));
    public static final List<String> DEFAULT_EXCLUDED_EXTENSIONS = Collections.singletonList("xml");
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Map<String, Value> globalVarTable = new HashMap<String, Value>();
    private final Map<String, Value> localVarTable = new HashMap<String, Value>();
    private final Map<String, SpecialVariableProcessor> mapVariableNameToSpecialVarProcessor = new HashMap<String, SpecialVariableProcessor>();
    private final Map<String, Object> sharedResources = new HashMap<String, Object>();
    private final List<File> configFiles = new ArrayList<File>();
    private final boolean cloned;
    private final TextFileDataContainer currentInCloneSource;
    private final List<SourceFolder> sources = new ArrayList<SourceFolder>();
    private final File baseDir;
    private final Collection<File> activatedConfigFiles;
    private final Collection<FileInfoContainer> preprocessedResources;
    private final AtomicReference<PreprocessingState> preprocessingState = new AtomicReference();
    private String eol = GetUtils.ensureNonNull(System.getProperty("jcp.line.separator", System.getProperty("line.separator")), "\n");
    private boolean verbose = false;
    private boolean keepComments = true;
    private boolean clearTarget = false;
    private boolean dryRun = false;
    private boolean keepLines = false;
    private boolean careForLastEol = false;
    private boolean dontOverwriteSameContent = false;
    private boolean allowWhitespaces = false;
    private boolean preserveIndents = false;
    private boolean keepAttributes = false;
    private boolean unknownVariableAsFalse = false;
    private File target;
    private Set<String> extensions = new HashSet<String>(DEFAULT_PROCESSING_EXTENSIONS);
    private Set<String> excludeExtensions = new HashSet<String>(DEFAULT_EXCLUDED_EXTENSIONS);
    private PreprocessorExtension preprocessorExtension;
    private Charset sourceEncoding = DEFAULT_CHARSET;
    private Charset targetEncoding = DEFAULT_CHARSET;
    private PreprocessorLogger preprocessorLogger = new SystemOutLogger();
    private List<String> excludeFolders = new ArrayList<String>();

    public PreprocessorContext(File baseDir) {
        this.preprocessedResources = new ArrayList<FileInfoContainer>();
        this.activatedConfigFiles = new ArrayList<File>();
        this.baseDir = Objects.requireNonNull(baseDir, "Base folder must not be null");
        this.preprocessingState.set(new PreprocessingState(this, this.sourceEncoding, this.targetEncoding));
        this.setSources(DEFAULT_SOURCE_DIRECTORY).setTarget(new File(DEFAULT_DEST_DIRECTORY));
        this.registerSpecialVariableProcessor(new JCPSpecialVariableProcessor());
        this.registerSpecialVariableProcessor(new EnvironmentVariableProcessor());
        this.cloned = false;
        this.currentInCloneSource = null;
    }

    public PreprocessorContext(PreprocessorContext context) {
        Objects.requireNonNull(context, "Source context must not be null");
        this.activatedConfigFiles = context.activatedConfigFiles;
        this.preprocessedResources = context.preprocessedResources;
        this.baseDir = context.getBaseDir();
        this.verbose = context.isVerbose();
        this.keepComments = context.isKeepComments();
        this.clearTarget = context.isClearTarget();
        this.dryRun = context.isDryRun();
        this.keepLines = context.isKeepLines();
        this.allowWhitespaces = context.isAllowWhitespaces();
        this.preserveIndents = context.isPreserveIndents();
        this.sources.addAll(context.sources);
        this.target = context.getTarget();
        this.keepAttributes = context.isKeepAttributes();
        this.careForLastEol = context.isCareForLastEol();
        this.extensions.clear();
        this.extensions.addAll(context.extensions);
        this.excludeExtensions.clear();
        this.excludeExtensions.addAll(context.excludeExtensions);
        this.unknownVariableAsFalse = context.unknownVariableAsFalse;
        this.preprocessorExtension = context.getPreprocessorExtension();
        this.sourceEncoding = context.getSourceEncoding();
        this.targetEncoding = context.getTargetEncoding();
        this.dontOverwriteSameContent = context.isDontOverwriteSameContent();
        this.eol = context.getEol();
        this.globalVarTable.clear();
        this.globalVarTable.putAll(context.getGlobalVarTable());
        this.localVarTable.clear();
        this.localVarTable.putAll(context.getLocalVarTable());
        this.excludeFolders = new ArrayList<String>(context.getExcludeFolders());
        this.mapVariableNameToSpecialVarProcessor.putAll(context.getMapVariableNameToSpecialVarProcessor());
        this.sharedResources.putAll(context.getSharedResources());
        this.configFiles.clear();
        this.configFiles.addAll(context.getConfigFiles());
        this.preprocessingState.set(Objects.requireNonNull(context.getPreprocessingState()));
        this.cloned = true;
        this.preprocessorLogger = context.getPreprocessorLogger();
        this.currentInCloneSource = context.getPreprocessingState().peekFile();
    }

    public void addPreprocessedResource(FileInfoContainer container) {
        if (container != null) {
            this.preprocessedResources.add(container);
        }
    }

    public void addAllPreprocessedResources(Collection<FileInfoContainer> containers) {
        if (containers != null) {
            this.preprocessedResources.addAll(containers);
        }
    }

    public Set<FileInfoContainer> findPreprocessedResources() {
        return new HashSet<FileInfoContainer>(this.preprocessedResources);
    }

    private static String makeStackView(TextFileDataContainer cloneSource, boolean cloned, List<TextFileDataContainer> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int tab = 5;
        for (int s = 0; s < tab; ++s) {
            builder.append(' ');
        }
        builder.append('{');
        if (cloned) {
            builder.append(cloneSource == null ? "*No src info" : "*" + cloneSource.getFile().getName() + ':' + cloneSource.getNextStringIndex());
        } else {
            builder.append("File chain");
        }
        builder.append('}');
        tab += 5;
        int fileIndex = 1;
        for (int i = list.size() - 1; i >= 0; --i) {
            TextFileDataContainer cur = list.get(i);
            builder.append('\n');
            for (int s = 0; s < tab; ++s) {
                builder.append(' ');
            }
            builder.append("\u2514>");
            builder.append(fileIndex++).append(". ");
            builder.append(cur.getFile().getName()).append(':').append(cur.getLastReadStringIndex() + 1);
            tab += 3;
        }
        return builder.toString();
    }

    private static Charset decodeCharset(String charsetName) {
        String normalized = charsetName.trim();
        if (Charset.isSupported(normalized)) {
            return Charset.forName(normalized);
        }
        throw new IllegalArgumentException("Unsupported charset: " + charsetName);
    }

    public Set<File> findAllInputFiles() {
        HashSet<File> result = new HashSet<File>();
        result.addAll(this.configFiles);
        this.preprocessedResources.forEach(x -> {
            result.addAll(x.getIncludedSources());
            if (!(x.getSourceFile() == null || x.getIncludedSources().isEmpty() && x.isExcludedFromPreprocessing())) {
                result.add(x.getSourceFile());
            }
        });
        return result;
    }

    public Set<File> findAllProducedFiles() {
        return this.preprocessedResources.stream().flatMap(x -> x.getGeneratedResources().stream()).collect(Collectors.toSet());
    }

    public Optional<FileInfoContainer> findFileInfoContainer(File file) {
        if (file == null) {
            return Optional.empty();
        }
        return this.preprocessedResources.stream().filter(x -> file.equals(x.getSourceFile())).findFirst();
    }

    public void setEol(String eol) {
        this.eol = Objects.requireNonNull(eol);
    }

    public void setTarget(File file) {
        this.target = file.isAbsolute() ? file : new File(this.getBaseDir(), file.getPath());
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setPreprocessorLogger(PreprocessorLogger logger) {
        this.preprocessorLogger = logger;
    }

    public void registerSpecialVariableProcessor(SpecialVariableProcessor processor) {
        Objects.requireNonNull(processor, "Processor is null");
        for (String varName : processor.getVariableNames()) {
            Objects.requireNonNull(varName, "A Special Var name is null");
            if (this.mapVariableNameToSpecialVarProcessor.containsKey(varName)) {
                throw new IllegalStateException("There is already defined processor for " + varName);
            }
            this.mapVariableNameToSpecialVarProcessor.put(varName, processor);
        }
    }

    public void logInfo(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.info(text);
        }
    }

    public void logError(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.error(text);
        }
    }

    public void logDebug(String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.debug(text);
        }
    }

    public void logWarning(String text) {
        if (text != null || this.preprocessorLogger != null) {
            this.preprocessorLogger.warning(text);
        }
    }

    public void setSharedResource(String name, Object obj) {
        Objects.requireNonNull(name, "Name is null");
        Objects.requireNonNull(obj, "Object is null");
        this.sharedResources.put(name, obj);
    }

    public Object getSharedResource(String name) {
        Objects.requireNonNull(name, "Name is null");
        return this.sharedResources.get(name);
    }

    public Object removeSharedResource(String name) {
        Objects.requireNonNull(name, "Name is null");
        return this.sharedResources.remove(name);
    }

    public PreprocessorContext setSources(List<String> folderPaths) {
        this.sources.clear();
        this.sources.addAll(folderPaths.stream().map(x -> new SourceFolder(this.baseDir, (String)x)).collect(Collectors.toList()));
        return this;
    }

    public Set<String> getExtensions() {
        return this.extensions;
    }

    public PreprocessorContext setExtensions(List<String> extensions) {
        this.extensions = new HashSet<String>((Collection)Objects.requireNonNull(extensions));
        return this;
    }

    public final boolean isFileAllowedForPreprocessing(File file) {
        boolean result = false;
        if (file != null && file.isFile() && file.length() != 0L) {
            result = this.extensions.contains(PreprocessorUtils.getFileExtension(file));
        }
        return result;
    }

    public final boolean isFileExcludedByExtension(File file) {
        return file == null || !file.isFile() || this.excludeExtensions.contains(PreprocessorUtils.getFileExtension(file));
    }

    public Set<String> getExcludeExtensions() {
        return this.excludeExtensions;
    }

    public PreprocessorContext setExcludeExtensions(List<String> extensions) {
        this.excludeExtensions = new HashSet<String>((Collection)Objects.requireNonNull(extensions));
        return this;
    }

    public PreprocessorContext setLocalVariable(String name, Value value) {
        Objects.requireNonNull(name, "Variable name is null");
        Objects.requireNonNull(value, "Value is null");
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Not defined variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to set either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        this.localVarTable.put(normalized, value);
        return this;
    }

    public PreprocessorContext removeLocalVariable(String name) {
        Objects.requireNonNull(name, "Variable name is null");
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to remove either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing local variable '" + normalized + "'");
        }
        this.localVarTable.remove(normalized);
        return this;
    }

    public PreprocessorContext removeGlobalVariable(String name) {
        Objects.requireNonNull(name, "Variable name is null");
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized)) {
            throw this.makeException("Attempting to remove a special variable as a global one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing global variable '" + normalized + "'");
        }
        this.globalVarTable.remove(normalized);
        return this;
    }

    public Value getLocalVariable(String name) {
        if (name == null) {
            return null;
        }
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return null;
        }
        return this.localVarTable.get(normalized);
    }

    public boolean containsLocalVariable(String name) {
        if (name == null) {
            return false;
        }
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return false;
        }
        return this.localVarTable.containsKey(normalized);
    }

    public PreprocessorContext clearLocalVariables() {
        this.localVarTable.clear();
        return this;
    }

    public PreprocessorContext setGlobalVariable(String name, Value value) {
        Objects.requireNonNull(name, "Variable name is null");
        String normalizedName = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalizedName.isEmpty()) {
            throw this.makeException("Name is empty", null);
        }
        Objects.requireNonNull(value, "Value is null");
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalizedName)) {
            this.mapVariableNameToSpecialVarProcessor.get(normalizedName).setVariable(normalizedName, value, this);
        } else {
            if (this.isVerbose()) {
                String valueAsStr = value.toString();
                if (this.globalVarTable.containsKey(normalizedName)) {
                    this.logForVerbose("Replacing global variable [" + normalizedName + '=' + valueAsStr + ']');
                } else {
                    this.logForVerbose("Defining new global variable [" + normalizedName + '=' + valueAsStr + ']');
                }
            }
            this.globalVarTable.put(normalizedName, value);
        }
        return this;
    }

    public boolean containsGlobalVariable(String name) {
        if (name == null) {
            return false;
        }
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return false;
        }
        return this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized);
    }

    public Value findVariableForName(String name, boolean enforceUnknownVarAsNull) {
        if (name == null) {
            return null;
        }
        String normalized = Objects.requireNonNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return null;
        }
        SpecialVariableProcessor processor = this.mapVariableNameToSpecialVarProcessor.get(normalized);
        if (processor != null) {
            return processor.getVariable(normalized, this);
        }
        Value val = this.getLocalVariable(normalized);
        if (val != null) {
            return val;
        }
        Value result = this.globalVarTable.get(normalized);
        if (result == null && !enforceUnknownVarAsNull && this.unknownVariableAsFalse) {
            this.logDebug("Unknown variable '" + name + "' is replaced by FALSE!");
            result = Value.BOOLEAN_FALSE;
        }
        return result;
    }

    public boolean isGlobalVariable(String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.globalVarTable.containsKey(normalized) || this.mapVariableNameToSpecialVarProcessor.containsKey(normalized);
        }
        return result;
    }

    public boolean isLocalVariable(String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.localVarTable.containsKey(normalized);
        }
        return result;
    }

    public File createDestinationFileForPath(String path) {
        Objects.requireNonNull(path, "Path is null");
        if (path.isEmpty()) {
            throw this.makeException("File name is empty", null);
        }
        return new File(this.getTarget(), path);
    }

    public File findFileInSources(String path) throws IOException {
        if (path == null) {
            throw this.makeException("File path is null", null);
        }
        if (path.trim().isEmpty()) {
            throw this.makeException("File path is empty", null);
        }
        File result = null;
        TextFileDataContainer theFile = this.getPreprocessingState().peekFile();
        String parentDir = theFile == null ? null : theFile.getFile().getParent();
        File resultFile = new File(path);
        if (resultFile.isAbsolute()) {
            String normalizedPath = FilenameUtils.normalizeNoEndSeparator(resultFile.getAbsolutePath());
            for (SourceFolder root2 : this.getSources()) {
                if (!normalizedPath.startsWith(root2.getNormalizedAbsolutePath(true))) continue;
                result = resultFile;
                break;
            }
            if (result == null) {
                throw this.makeException("Can't find file for path '" + path + "' in preprocessing source folders, allowed usage only files in preprocessing source folders!", null);
            }
            if (!result.isFile()) {
                throw this.makeException("File '" + result + "' is either not found or not a file", null);
            }
        } else if (parentDir != null) {
            result = new File(parentDir, path);
        } else {
            ArrayList setOfFoundFiles = new ArrayList();
            this.getSources().stream().map(root -> new File(root.getAsFile(), path)).filter(variant -> variant.exists() && variant.isFile()).forEachOrdered(setOfFoundFiles::add);
            if (setOfFoundFiles.size() == 1) {
                result = (File)setOfFoundFiles.get(0);
            } else if (setOfFoundFiles.isEmpty()) {
                result = null;
            } else {
                throw this.makeException("Found several variants for path '" + path + "' in different source roots", null);
            }
            if (result == null) {
                throw this.makeException("Can't find file for path '" + path + "' among source files registered for preprocessing.", null);
            }
            if (!result.isFile()) {
                throw this.makeException("File '" + PreprocessorUtils.getFilePath(result) + "' is either not found or not a file", null);
            }
        }
        return result;
    }

    public void registerConfigFile(File file) {
        Objects.requireNonNull(file, "File is null");
        this.configFiles.add(file.isAbsolute() ? file : new File(this.getBaseDir(), file.getPath()));
    }

    public PreprocessingState produceNewPreprocessingState(FileInfoContainer fileContainer, int phaseIndex) throws IOException {
        Objects.requireNonNull(fileContainer, "File container is null");
        if (this.verbose) {
            if (phaseIndex == 0) {
                this.logInfo("Start search global definitions in '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            } else {
                this.logInfo("Start preprocessing '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            }
        }
        this.preprocessingState.set(new PreprocessingState(this, fileContainer, this.getSourceEncoding(), this.getTargetEncoding(), this.isDontOverwriteSameContent()));
        return this.getPreprocessingState();
    }

    public PreprocessingState produceNewPreprocessingState(FileInfoContainer fileContainer, TextFileDataContainer textContainer) {
        this.preprocessingState.set(new PreprocessingState(this, fileContainer, textContainer, this.getSourceEncoding(), this.getTargetEncoding(), this.isDontOverwriteSameContent()));
        return this.getPreprocessingState();
    }

    public PreprocessingState getPreprocessingState() {
        return this.preprocessingState.get();
    }

    public PreprocessorException makeException(String text, Throwable cause) {
        if (cause instanceof PreprocessorException) {
            return (PreprocessorException)cause;
        }
        FilePositionInfo[] includeStack = this.getPreprocessingState().makeIncludeStack();
        String sourceLine = this.getPreprocessingState().getLastReadString();
        return new PreprocessorException(text, sourceLine, includeStack, cause);
    }

    public void logForVerbose(String str) {
        if (this.isVerbose()) {
            String stack = PreprocessorContext.makeStackView(this.currentInCloneSource, this.cloned, this.getPreprocessingState().getCurrentIncludeStack());
            this.logInfo(str + (stack.isEmpty() ? (char)' ' : '\n') + stack);
        }
    }

    public Map<String, Value> getGlobalVarTable() {
        return this.globalVarTable;
    }

    public Map<String, Value> getLocalVarTable() {
        return this.localVarTable;
    }

    public Map<String, SpecialVariableProcessor> getMapVariableNameToSpecialVarProcessor() {
        return this.mapVariableNameToSpecialVarProcessor;
    }

    public Map<String, Object> getSharedResources() {
        return this.sharedResources;
    }

    public List<File> getConfigFiles() {
        return this.configFiles;
    }

    public TextFileDataContainer getCurrentInCloneSource() {
        return this.currentInCloneSource;
    }

    public List<SourceFolder> getSources() {
        return this.sources;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Collection<File> getActivatedConfigFiles() {
        return this.activatedConfigFiles;
    }

    public String getEol() {
        return this.eol;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public boolean isClearTarget() {
        return this.clearTarget;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }

    public boolean isCareForLastEol() {
        return this.careForLastEol;
    }

    public boolean isDontOverwriteSameContent() {
        return this.dontOverwriteSameContent;
    }

    public boolean isAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    public boolean isPreserveIndents() {
        return this.preserveIndents;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    public boolean isUnknownVariableAsFalse() {
        return this.unknownVariableAsFalse;
    }

    public File getTarget() {
        return this.target;
    }

    public PreprocessorExtension getPreprocessorExtension() {
        return this.preprocessorExtension;
    }

    public Charset getSourceEncoding() {
        return this.sourceEncoding;
    }

    public Charset getTargetEncoding() {
        return this.targetEncoding;
    }

    public PreprocessorLogger getPreprocessorLogger() {
        return this.preprocessorLogger;
    }

    public List<String> getExcludeFolders() {
        return this.excludeFolders;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public void setClearTarget(boolean clearTarget) {
        this.clearTarget = clearTarget;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public void setCareForLastEol(boolean careForLastEol) {
        this.careForLastEol = careForLastEol;
    }

    public void setDontOverwriteSameContent(boolean dontOverwriteSameContent) {
        this.dontOverwriteSameContent = dontOverwriteSameContent;
    }

    public void setAllowWhitespaces(boolean allowWhitespaces) {
        this.allowWhitespaces = allowWhitespaces;
    }

    public void setPreserveIndents(boolean preserveIndents) {
        this.preserveIndents = preserveIndents;
    }

    public void setKeepAttributes(boolean keepAttributes) {
        this.keepAttributes = keepAttributes;
    }

    public void setUnknownVariableAsFalse(boolean unknownVariableAsFalse) {
        this.unknownVariableAsFalse = unknownVariableAsFalse;
    }

    public void setPreprocessorExtension(PreprocessorExtension preprocessorExtension) {
        this.preprocessorExtension = preprocessorExtension;
    }

    public void setSourceEncoding(Charset sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setTargetEncoding(Charset targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public void setExcludeFolders(List<String> excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreprocessorContext)) {
            return false;
        }
        PreprocessorContext other = (PreprocessorContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCloned() != other.isCloned()) {
            return false;
        }
        if (this.isVerbose() != other.isVerbose()) {
            return false;
        }
        if (this.isKeepComments() != other.isKeepComments()) {
            return false;
        }
        if (this.isClearTarget() != other.isClearTarget()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isKeepLines() != other.isKeepLines()) {
            return false;
        }
        if (this.isCareForLastEol() != other.isCareForLastEol()) {
            return false;
        }
        if (this.isDontOverwriteSameContent() != other.isDontOverwriteSameContent()) {
            return false;
        }
        if (this.isAllowWhitespaces() != other.isAllowWhitespaces()) {
            return false;
        }
        if (this.isPreserveIndents() != other.isPreserveIndents()) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        if (this.isUnknownVariableAsFalse() != other.isUnknownVariableAsFalse()) {
            return false;
        }
        Map<String, Value> this$globalVarTable = this.getGlobalVarTable();
        Map<String, Value> other$globalVarTable = other.getGlobalVarTable();
        if (this$globalVarTable == null ? other$globalVarTable != null : !((Object)this$globalVarTable).equals(other$globalVarTable)) {
            return false;
        }
        Map<String, Value> this$localVarTable = this.getLocalVarTable();
        Map<String, Value> other$localVarTable = other.getLocalVarTable();
        if (this$localVarTable == null ? other$localVarTable != null : !((Object)this$localVarTable).equals(other$localVarTable)) {
            return false;
        }
        Map<String, SpecialVariableProcessor> this$mapVariableNameToSpecialVarProcessor = this.getMapVariableNameToSpecialVarProcessor();
        Map<String, SpecialVariableProcessor> other$mapVariableNameToSpecialVarProcessor = other.getMapVariableNameToSpecialVarProcessor();
        if (this$mapVariableNameToSpecialVarProcessor == null ? other$mapVariableNameToSpecialVarProcessor != null : !((Object)this$mapVariableNameToSpecialVarProcessor).equals(other$mapVariableNameToSpecialVarProcessor)) {
            return false;
        }
        Map<String, Object> this$sharedResources = this.getSharedResources();
        Map<String, Object> other$sharedResources = other.getSharedResources();
        if (this$sharedResources == null ? other$sharedResources != null : !((Object)this$sharedResources).equals(other$sharedResources)) {
            return false;
        }
        List<File> this$configFiles = this.getConfigFiles();
        List<File> other$configFiles = other.getConfigFiles();
        if (this$configFiles == null ? other$configFiles != null : !((Object)this$configFiles).equals(other$configFiles)) {
            return false;
        }
        TextFileDataContainer this$currentInCloneSource = this.getCurrentInCloneSource();
        TextFileDataContainer other$currentInCloneSource = other.getCurrentInCloneSource();
        if (this$currentInCloneSource == null ? other$currentInCloneSource != null : !((Object)this$currentInCloneSource).equals(other$currentInCloneSource)) {
            return false;
        }
        List<SourceFolder> this$sources = this.getSources();
        List<SourceFolder> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        File this$baseDir = this.getBaseDir();
        File other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
            return false;
        }
        Collection<File> this$activatedConfigFiles = this.getActivatedConfigFiles();
        Collection<File> other$activatedConfigFiles = other.getActivatedConfigFiles();
        if (this$activatedConfigFiles == null ? other$activatedConfigFiles != null : !((Object)this$activatedConfigFiles).equals(other$activatedConfigFiles)) {
            return false;
        }
        Collection<FileInfoContainer> this$preprocessedResources = this.preprocessedResources;
        Collection<FileInfoContainer> other$preprocessedResources = other.preprocessedResources;
        if (this$preprocessedResources == null ? other$preprocessedResources != null : !((Object)this$preprocessedResources).equals(other$preprocessedResources)) {
            return false;
        }
        PreprocessingState this$preprocessingState = this.getPreprocessingState();
        PreprocessingState other$preprocessingState = other.getPreprocessingState();
        if (this$preprocessingState == null ? other$preprocessingState != null : !this$preprocessingState.equals(other$preprocessingState)) {
            return false;
        }
        String this$eol = this.getEol();
        String other$eol = other.getEol();
        if (this$eol == null ? other$eol != null : !this$eol.equals(other$eol)) {
            return false;
        }
        File this$target = this.getTarget();
        File other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        Set<String> this$extensions = this.getExtensions();
        Set<String> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Set<String> this$excludeExtensions = this.getExcludeExtensions();
        Set<String> other$excludeExtensions = other.getExcludeExtensions();
        if (this$excludeExtensions == null ? other$excludeExtensions != null : !((Object)this$excludeExtensions).equals(other$excludeExtensions)) {
            return false;
        }
        PreprocessorExtension this$preprocessorExtension = this.getPreprocessorExtension();
        PreprocessorExtension other$preprocessorExtension = other.getPreprocessorExtension();
        if (this$preprocessorExtension == null ? other$preprocessorExtension != null : !this$preprocessorExtension.equals(other$preprocessorExtension)) {
            return false;
        }
        Charset this$sourceEncoding = this.getSourceEncoding();
        Charset other$sourceEncoding = other.getSourceEncoding();
        if (this$sourceEncoding == null ? other$sourceEncoding != null : !((Object)this$sourceEncoding).equals(other$sourceEncoding)) {
            return false;
        }
        Charset this$targetEncoding = this.getTargetEncoding();
        Charset other$targetEncoding = other.getTargetEncoding();
        if (this$targetEncoding == null ? other$targetEncoding != null : !((Object)this$targetEncoding).equals(other$targetEncoding)) {
            return false;
        }
        PreprocessorLogger this$preprocessorLogger = this.getPreprocessorLogger();
        PreprocessorLogger other$preprocessorLogger = other.getPreprocessorLogger();
        if (this$preprocessorLogger == null ? other$preprocessorLogger != null : !this$preprocessorLogger.equals(other$preprocessorLogger)) {
            return false;
        }
        List<String> this$excludeFolders = this.getExcludeFolders();
        List<String> other$excludeFolders = other.getExcludeFolders();
        return !(this$excludeFolders == null ? other$excludeFolders != null : !((Object)this$excludeFolders).equals(other$excludeFolders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreprocessorContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCloned() ? 79 : 97);
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        result = result * 59 + (this.isKeepComments() ? 79 : 97);
        result = result * 59 + (this.isClearTarget() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isKeepLines() ? 79 : 97);
        result = result * 59 + (this.isCareForLastEol() ? 79 : 97);
        result = result * 59 + (this.isDontOverwriteSameContent() ? 79 : 97);
        result = result * 59 + (this.isAllowWhitespaces() ? 79 : 97);
        result = result * 59 + (this.isPreserveIndents() ? 79 : 97);
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        result = result * 59 + (this.isUnknownVariableAsFalse() ? 79 : 97);
        Map<String, Value> $globalVarTable = this.getGlobalVarTable();
        result = result * 59 + ($globalVarTable == null ? 43 : ((Object)$globalVarTable).hashCode());
        Map<String, Value> $localVarTable = this.getLocalVarTable();
        result = result * 59 + ($localVarTable == null ? 43 : ((Object)$localVarTable).hashCode());
        Map<String, SpecialVariableProcessor> $mapVariableNameToSpecialVarProcessor = this.getMapVariableNameToSpecialVarProcessor();
        result = result * 59 + ($mapVariableNameToSpecialVarProcessor == null ? 43 : ((Object)$mapVariableNameToSpecialVarProcessor).hashCode());
        Map<String, Object> $sharedResources = this.getSharedResources();
        result = result * 59 + ($sharedResources == null ? 43 : ((Object)$sharedResources).hashCode());
        List<File> $configFiles = this.getConfigFiles();
        result = result * 59 + ($configFiles == null ? 43 : ((Object)$configFiles).hashCode());
        TextFileDataContainer $currentInCloneSource = this.getCurrentInCloneSource();
        result = result * 59 + ($currentInCloneSource == null ? 43 : ((Object)$currentInCloneSource).hashCode());
        List<SourceFolder> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        File $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
        Collection<File> $activatedConfigFiles = this.getActivatedConfigFiles();
        result = result * 59 + ($activatedConfigFiles == null ? 43 : ((Object)$activatedConfigFiles).hashCode());
        Collection<FileInfoContainer> $preprocessedResources = this.preprocessedResources;
        result = result * 59 + ($preprocessedResources == null ? 43 : ((Object)$preprocessedResources).hashCode());
        PreprocessingState $preprocessingState = this.getPreprocessingState();
        result = result * 59 + ($preprocessingState == null ? 43 : $preprocessingState.hashCode());
        String $eol = this.getEol();
        result = result * 59 + ($eol == null ? 43 : $eol.hashCode());
        File $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        Set<String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Set<String> $excludeExtensions = this.getExcludeExtensions();
        result = result * 59 + ($excludeExtensions == null ? 43 : ((Object)$excludeExtensions).hashCode());
        PreprocessorExtension $preprocessorExtension = this.getPreprocessorExtension();
        result = result * 59 + ($preprocessorExtension == null ? 43 : $preprocessorExtension.hashCode());
        Charset $sourceEncoding = this.getSourceEncoding();
        result = result * 59 + ($sourceEncoding == null ? 43 : ((Object)$sourceEncoding).hashCode());
        Charset $targetEncoding = this.getTargetEncoding();
        result = result * 59 + ($targetEncoding == null ? 43 : ((Object)$targetEncoding).hashCode());
        PreprocessorLogger $preprocessorLogger = this.getPreprocessorLogger();
        result = result * 59 + ($preprocessorLogger == null ? 43 : $preprocessorLogger.hashCode());
        List<String> $excludeFolders = this.getExcludeFolders();
        result = result * 59 + ($excludeFolders == null ? 43 : ((Object)$excludeFolders).hashCode());
        return result;
    }

    public String toString() {
        return "PreprocessorContext(globalVarTable=" + this.getGlobalVarTable() + ", localVarTable=" + this.getLocalVarTable() + ", mapVariableNameToSpecialVarProcessor=" + this.getMapVariableNameToSpecialVarProcessor() + ", sharedResources=" + this.getSharedResources() + ", configFiles=" + this.getConfigFiles() + ", cloned=" + this.isCloned() + ", currentInCloneSource=" + this.getCurrentInCloneSource() + ", sources=" + this.getSources() + ", baseDir=" + this.getBaseDir() + ", activatedConfigFiles=" + this.getActivatedConfigFiles() + ", preprocessedResources=" + this.preprocessedResources + ", preprocessingState=" + this.getPreprocessingState() + ", eol=" + this.getEol() + ", verbose=" + this.isVerbose() + ", keepComments=" + this.isKeepComments() + ", clearTarget=" + this.isClearTarget() + ", dryRun=" + this.isDryRun() + ", keepLines=" + this.isKeepLines() + ", careForLastEol=" + this.isCareForLastEol() + ", dontOverwriteSameContent=" + this.isDontOverwriteSameContent() + ", allowWhitespaces=" + this.isAllowWhitespaces() + ", preserveIndents=" + this.isPreserveIndents() + ", keepAttributes=" + this.isKeepAttributes() + ", unknownVariableAsFalse=" + this.isUnknownVariableAsFalse() + ", target=" + this.getTarget() + ", extensions=" + this.getExtensions() + ", excludeExtensions=" + this.getExcludeExtensions() + ", preprocessorExtension=" + this.getPreprocessorExtension() + ", sourceEncoding=" + this.getSourceEncoding() + ", targetEncoding=" + this.getTargetEncoding() + ", preprocessorLogger=" + this.getPreprocessorLogger() + ", excludeFolders=" + this.getExcludeFolders() + ")";
    }

    public static final class SourceFolder {
        private final String path;
        private final File pathFile;

        public SourceFolder(File baseDir, String path) {
            this.path = Objects.requireNonNull(path);
            File pathAsFile = new File(path);
            this.pathFile = pathAsFile.isAbsolute() ? pathAsFile : new File(baseDir, path);
        }

        public String getAsString() {
            return this.path;
        }

        public File getAsFile() {
            return this.pathFile;
        }

        public String getNormalizedAbsolutePath(boolean separatorCharEnded) {
            String result = FilenameUtils.normalizeNoEndSeparator(this.pathFile.getAbsolutePath());
            if (separatorCharEnded) {
                result = result + File.separatorChar;
            }
            return result;
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.path);
        }
    }
}

