/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class ErrorDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "error";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.EXPRESSTION;
    }

    @Override
    public String getReference() {
        return "throw fatal preprocessor exception with message and stop work";
    }

    protected void process(PreprocessorContext context, String message) {
        String text = PreprocessorUtils.processMacroses(message, context);
        context.logError(text);
        throw context.makeException(text, null);
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String trimmedString, PreprocessorContext context) {
        String message = trimmedString.isEmpty() ? "Thrown fatal error" : Expression.evalExpression(trimmedString, context).toString();
        this.process(context, message);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

