/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.io.IOException;

public class FlushDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "flush";
    }

    @Override
    public String getReference() {
        return "force buffered texts to be written out then clear buffers";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (!context.isDryRun()) {
            File outFile = context.createDestinationFileForPath(state.getRootFileInfo().makeTargetFilePathAsString());
            try {
                if (context.isVerbose()) {
                    context.logForVerbose("Flushing buffers into file '" + outFile + '\'');
                }
                boolean saved = state.saveBuffersToFile(outFile, context.isKeepComments());
                if (context.isVerbose()) {
                    context.logForVerbose("Content was " + (saved ? "saved" : "not saved") + " into file '" + outFile + "'");
                }
                PreprocessorUtils.findFirstActiveFileContainer(context).ifPresent(f -> f.getGeneratedResources().add(outFile));
                state.resetPrinters();
            }
            catch (IOException ex) {
                throw context.makeException("Can't flush text buffers", ex);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

