/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;

public class GlobalIfDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "_if";
    }

    @Override
    public String getReference() {
        return "start " + this.getFullName() + ".." + "//#" + "_endif control structure";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.BOOLEAN;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }

    @Override
    public boolean isGlobalPhaseAllowed() {
        return true;
    }

    @Override
    public boolean isPreprocessingPhaseAllowed() {
        return false;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isDirectiveCanBeProcessed()) {
            Value expressionResult = Expression.evalExpression(string, context);
            if (expressionResult.getType() != ValueType.BOOLEAN) {
                throw context.makeException("Non boolean argument", null);
            }
            state.pushIf(true);
            if (!expressionResult.asBoolean().booleanValue()) {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        } else {
            state.pushIf(false);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

