/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class LocalDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "local";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        this.processLocalDefinition(string, context);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public String getReference() {
        return "local variable definition, visibility bounded by current file";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.SET;
    }

    private void processLocalDefinition(String string, PreprocessorContext context) {
        String[] splitted = PreprocessorUtils.splitForEqualChar(string);
        if (splitted.length != 2) {
            throw context.makeException("Can't find expression", null);
        }
        String name = splitted[0];
        Value value = Expression.evalExpression(splitted[1], context);
        context.setLocalVariable(name, value);
    }
}

