/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import java.util.Objects;

public class NoAutoFlushHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "noautoflush";
    }

    @Override
    public String getReference() {
        return "turn off auto-flush when EOF";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (context.isVerbose()) {
            context.logForVerbose("Disabling auto-flush");
        }
        Objects.requireNonNull(state.peekFile(), "File stack is empty!").disableAutoFlush();
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

