/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;

public class PostfixDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "postfix";
    }

    @Override
    public String getReference() {
        return "turn on(+) or turn off(-) output into postfix section";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.ONOFF;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case '+': {
                    state.setPrinter(PreprocessingState.PrinterType.POSTFIX);
                    break;
                }
                case '-': {
                    state.setPrinter(PreprocessingState.PrinterType.NORMAL);
                    break;
                }
                default: {
                    throw context.makeException("Unsupported ending [" + string + ']', null);
                }
            }
            return AfterDirectiveProcessingBehaviour.PROCESSED;
        }
        throw context.makeException(this.getFullName() + " needs ending [+|-]", null);
    }
}

