/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;

public class WhileDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "while";
    }

    @Override
    public String getReference() {
        return "starts " + this.getFullName() + ".." + "//#" + "end loop";
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.BOOLEAN;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isDirectiveCanBeProcessed()) {
            Value condition = Expression.evalExpression(string, context);
            if (condition.getType() != ValueType.BOOLEAN) {
                throw context.makeException("Non boolean argument", null);
            }
            state.pushWhile(true);
            if (!condition.asBoolean().booleanValue()) {
                state.getPreprocessingFlags().add(PreprocessingFlag.BREAK_COMMAND);
            }
        } else {
            state.pushWhile(false);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

