/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;

public final class FunctionIS
extends AbstractFunction {
    private static final ValueType[][] SIGNATURES = new ValueType[][]{{ValueType.STRING, ValueType.ANY}};

    @Override
    public String getName() {
        return "is";
    }

    public Value executeStrAny(PreprocessorContext context, Value varName, Value value) {
        Value currentValue = context.findVariableForName(varName.asString(), false);
        Value result = Value.BOOLEAN_FALSE;
        if (currentValue != null) {
            result = value.toString().compareTo(currentValue.toString()) == 0 ? Value.BOOLEAN_TRUE : Value.BOOLEAN_FALSE;
        }
        return result;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return SIGNATURES;
    }

    @Override
    public String getReference() {
        return "check that string is string form of value";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.BOOLEAN;
    }
}

