/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;

public final class FunctionROUND
extends AbstractFunction {
    private static final ValueType[][] SIGNATURES = new ValueType[][]{{ValueType.FLOAT}, {ValueType.INT}};

    @Override
    public String getName() {
        return "round";
    }

    public Value executeInt(PreprocessorContext context, Value value) {
        return value;
    }

    public Value executeFloat(PreprocessorContext context, Value value) {
        return Value.valueOf(Long.valueOf(Math.round(value.asFloat().floatValue())));
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return SIGNATURES;
    }

    @Override
    public String getReference() {
        return "round float value to nearest integer";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.INT;
    }
}

