/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractStrConverter;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public final class FunctionTRIMLINES
extends AbstractStrConverter {
    @Override
    public String getName() {
        return "trimlines";
    }

    @Override
    public Value executeStr(PreprocessorContext context, Value value) {
        String text = value.asString();
        StringBuilder result = new StringBuilder(text.length());
        for (String s : PreprocessorUtils.splitForChar(text, '\n')) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(PreprocessorUtils.getNextLineCodes());
            }
            result.append(trimmed);
        }
        return Value.valueOf(result.toString());
    }

    @Override
    public String getReference() {
        return "trim each line found in string, remove empty lines";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

