/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import hidden.jcp.javax.xml.parsers.ParserConfigurationException;
import hidden.jcp.org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import hidden.jcp.org.w3c.dom.Document;
import hidden.jcp.org.xml.sax.SAXException;
import java.io.File;
import java.io.IOException;

public final class FunctionXML_OPEN
extends AbstractXMLFunction {
    public static final String RES_XML_DOC_PREFIX = "xml_doc_";
    public static final String RES_XML_ELEMENT_PREFIX = "xml_elem_";
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    public String getName() {
        return "xml_open";
    }

    public Value executeStr(PreprocessorContext context, Value filePath) {
        String name = filePath.asString();
        String documentId = FunctionXML_OPEN.makeDocumentId(name);
        String documentIdRoot = FunctionXML_OPEN.makeDocumentRootId(documentId);
        NodeContainer docContainer = (NodeContainer)context.getSharedResource(documentId);
        if (docContainer == null) {
            File file;
            try {
                file = context.findFileInSources(name);
            }
            catch (IOException unexpected) {
                throw context.makeException("Can't read '" + name + '\'', null);
            }
            Document document = this.openFileAndParse(context, file);
            PreprocessorUtils.findFirstActiveFileContainer(context).ifPresent(t -> t.getIncludedSources().add(file));
            docContainer = new NodeContainer(UID_COUNTER.getAndIncrement(), document);
            context.setSharedResource(documentId, docContainer);
            NodeContainer rootContainer = new NodeContainer(UID_COUNTER.getAndIncrement(), document.getDocumentElement());
            context.setSharedResource(documentIdRoot, rootContainer);
        }
        return Value.valueOf(documentId);
    }

    private Document openFileAndParse(PreprocessorContext context, File file) {
        DocumentBuilderFactoryImpl docBuilderFactory = new DocumentBuilderFactoryImpl();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setCoalescing(true);
        docBuilderFactory.setValidating(false);
        try {
            return docBuilderFactory.newDocumentBuilder().parse(file);
        }
        catch (ParserConfigurationException unexpected) {
            throw context.makeException("XML parser configuration exception", unexpected);
        }
        catch (SAXException unexpected) {
            throw context.makeException("Exception during XML parsing", unexpected);
        }
        catch (IOException unexpected) {
            throw context.makeException("Can't read XML file", unexpected);
        }
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public String getReference() {
        return "open and parse XML file";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

