/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import hidden.jcp.javax.xml.xpath.XPathConstants;
import hidden.jcp.javax.xml.xpath.XPathExpression;
import hidden.jcp.javax.xml.xpath.XPathExpressionException;
import hidden.jcp.org.w3c.dom.Document;
import hidden.jcp.org.w3c.dom.NodeList;

public final class FunctionXML_XLIST
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    public String getName() {
        return "xml_xlist";
    }

    public Value executeStrStr(PreprocessorContext context, Value documentId, Value xPath) {
        String documentIdStr = documentId.asString();
        String pathStr = xPath.asString();
        String xpathId = FunctionXML_XLIST.makeXPathListId(documentIdStr, pathStr);
        Document document = this.getCachedDocument(context, documentIdStr);
        NodeList list = this.findCachedElementList(context, xpathId);
        if (list == null) {
            try {
                XPathExpression expression = FunctionXML_XLIST.prepareXPathExpression(pathStr);
                list = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw context.makeException("Error during XPath compilation [" + pathStr + ']', ex);
            }
            NodeContainer container = new NodeContainer(UID_COUNTER.getAndIncrement(), list);
            context.setSharedResource(xpathId, container);
        }
        return Value.valueOf(xpathId);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public String getReference() {
        return "find element list with XPath";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

