/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.gradle;

import com.igormaznitsa.jcp.JcpPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.commandline.TaskConfigurationException;

public class JcpTask
extends DefaultTask {
    public static final String ID = "preprocess";
    private final ListProperty<File> sources;
    private final Property<String> eol;
    private final Property<Boolean> keepAttributes;
    private final Property<File> target;
    private final Property<String> sourceEncoding;
    private final Property<String> targetEncoding;
    private final Property<Boolean> ignoreMissingSources;
    private final ListProperty<String> excludeExtensions;
    private final ListProperty<String> fileExtensions;
    private final Property<Boolean> unknownVarAsFalse;
    private final Property<Boolean> dryRun;
    private final Property<Boolean> verbose;
    private final Property<Boolean> clearTarget;
    private final Property<File> baseDir;
    private final Property<Boolean> careForLastEol;
    private final Property<Boolean> keepComments;
    private final MapProperty<String, String> vars;
    private final ListProperty<String> excludeFolders;
    private final ListProperty<String> configFiles;
    private final Property<Boolean> keepLines;
    private final Property<Boolean> allowWhitespaces;
    private final Property<Boolean> preserveIndents;
    private final Property<Boolean> dontOverwriteSameContent;
    private final ConfigurableFileCollection outcomingFiles;
    private final ConfigurableFileCollection incomingFiles;

    @Inject
    public JcpTask(ObjectFactory factory) {
        this.allowWhitespaces = factory.property(Boolean.class).convention((Object)false);
        this.careForLastEol = factory.property(Boolean.class).convention((Object)false);
        this.clearTarget = factory.property(Boolean.class).convention((Object)false);
        this.dontOverwriteSameContent = factory.property(Boolean.class).convention((Object)false);
        this.dryRun = factory.property(Boolean.class).convention((Object)false);
        this.ignoreMissingSources = factory.property(Boolean.class).convention((Object)false);
        this.keepAttributes = factory.property(Boolean.class).convention((Object)false);
        this.keepComments = factory.property(Boolean.class).convention((Object)true);
        this.keepLines = factory.property(Boolean.class).convention((Object)true);
        this.preserveIndents = factory.property(Boolean.class).convention((Object)false);
        this.unknownVarAsFalse = factory.property(Boolean.class).convention((Object)false);
        this.verbose = factory.property(Boolean.class).convention((Object)false);
        this.targetEncoding = factory.property(String.class).convention((Object)StandardCharsets.UTF_8.name());
        this.sourceEncoding = factory.property(String.class).convention((Object)StandardCharsets.UTF_8.name());
        this.eol = factory.property(String.class).convention((Object)System.lineSeparator());
        this.vars = factory.mapProperty(String.class, String.class);
        this.sources = factory.listProperty(File.class);
        this.configFiles = factory.listProperty(String.class);
        this.excludeExtensions = factory.listProperty(String.class).convention(Collections.singletonList("xml"));
        this.excludeFolders = factory.listProperty(String.class);
        this.fileExtensions = factory.listProperty(String.class).convention(new ArrayList<String>(Arrays.asList("java", "txt", "htm", "html")));
        this.baseDir = factory.property(File.class).convention((Object)this.getProject().getProjectDir());
        this.target = factory.property(File.class).convention((Object)new File(this.getProject().getBuildDir(), "java-comment-preprocessor" + File.separatorChar + this.getTaskIdentity().name));
        this.incomingFiles = factory.fileCollection();
        this.outcomingFiles = factory.fileCollection();
    }

    @OutputFiles
    public FileCollection getOutcomingFiles() {
        return this.outcomingFiles;
    }

    @Internal
    public FileCollection getIncomingFiles() {
        return this.incomingFiles;
    }

    @Internal
    public String getDescription() {
        return "Preprocess sources and resources with JCP";
    }

    @InputFiles
    public ListProperty<File> getSources() {
        return this.sources;
    }

    @Input
    public Property<String> getEol() {
        return this.eol;
    }

    @Input
    public Property<Boolean> getKeepAttributes() {
        return this.keepAttributes;
    }

    @Input
    public Property<File> getTarget() {
        return this.target;
    }

    @Input
    public Property<String> getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Input
    public Property<String> getTargetEncoding() {
        return this.targetEncoding;
    }

    @Input
    public Property<Boolean> getIgnoreMissingSources() {
        return this.ignoreMissingSources;
    }

    @Input
    public ListProperty<String> getExcludeExtensions() {
        return this.excludeExtensions;
    }

    @Input
    public ListProperty<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @Input
    public Property<Boolean> getUnknownVarAsFalse() {
        return this.unknownVarAsFalse;
    }

    @Input
    public Property<Boolean> getDryRun() {
        return this.dryRun;
    }

    @Input
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @Input
    public Property<Boolean> getClearTarget() {
        return this.clearTarget;
    }

    @Input
    public Property<File> getBaseDir() {
        return this.baseDir;
    }

    @Input
    public Property<Boolean> getCareForLastEol() {
        return this.careForLastEol;
    }

    @Input
    public Property<Boolean> getKeepComments() {
        return this.keepComments;
    }

    @Input
    public MapProperty<String, String> getVars() {
        return this.vars;
    }

    @Input
    public ListProperty<String> getExcludeFolders() {
        return this.excludeFolders;
    }

    @Input
    public ListProperty<String> getConfigFiles() {
        return this.configFiles;
    }

    @Input
    public Property<Boolean> getKeepLines() {
        return this.keepLines;
    }

    @Input
    public Property<Boolean> getAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    @Input
    public Property<Boolean> getPreserveIndents() {
        return this.preserveIndents;
    }

    @Input
    public Property<Boolean> getDontOverwriteSameContent() {
        return this.dontOverwriteSameContent;
    }

    @TaskAction
    public void preprocessTask() throws IOException {
        final Logger logger = this.getProject().getLogger();
        File baseDirFile = this.baseDir.isPresent() ? (File)this.baseDir.get() : this.getProject().getProjectDir();
        logger.info("Base folder: " + baseDirFile);
        PreprocessorContext preprocessorContext = new PreprocessorContext(baseDirFile);
        preprocessorContext.setPreprocessorLogger(new PreprocessorLogger(){

            @Override
            public void error(String message) {
                logger.error(message);
            }

            @Override
            public void info(String message) {
                logger.info(message);
            }

            @Override
            public void debug(String message) {
                logger.debug(message);
            }

            @Override
            public void warning(String message) {
                logger.warn(message);
            }
        });
        List configFilesList = (List)this.configFiles.get();
        configFilesList.forEach(x -> {
            File cfgFile = new File(baseDirFile, (String)x);
            if (!cfgFile.isFile()) {
                throw new TaskExecutionException((Task)this, (Throwable)new IOException("Can't find config file: " + FilenameUtils.normalize(cfgFile.getAbsolutePath())));
            }
            logger.debug("Adding config file: " + cfgFile);
            preprocessorContext.registerConfigFile(cfgFile);
        });
        File targetFolder = (File)this.target.get();
        logger.info("Target folder: " + targetFolder);
        preprocessorContext.setTarget(targetFolder);
        List sourcesList = (List)this.sources.get();
        if (sourcesList.isEmpty()) {
            throw new TaskConfigurationException(ID, "Source folder list must be defined as 'sources'", null);
        }
        ArrayList<File> preparedSourcesList = new ArrayList<File>();
        for (File srcFolder : sourcesList) {
            File srcFolderFile;
            File file = srcFolderFile = srcFolder.isAbsolute() ? srcFolder : new File(baseDirFile, srcFolder.getPath());
            if (!((Boolean)this.ignoreMissingSources.get()).booleanValue() || srcFolderFile.isDirectory()) {
                preparedSourcesList.add(srcFolderFile);
            }
            if (srcFolderFile.isDirectory()) continue;
            logger.debug(String.format("Src.folder doesn't exist: %s", srcFolderFile));
        }
        logger.info("Source folders in use: " + preparedSourcesList);
        preprocessorContext.setSources(preparedSourcesList.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        preprocessorContext.setEol((String)this.eol.get());
        preprocessorContext.setExcludeFolders((List)this.excludeFolders.get());
        preprocessorContext.setDontOverwriteSameContent((Boolean)this.dontOverwriteSameContent.get());
        preprocessorContext.setClearTarget((Boolean)this.clearTarget.get());
        preprocessorContext.setCareForLastEol((Boolean)this.careForLastEol.get());
        preprocessorContext.setKeepComments((Boolean)this.keepComments.get());
        preprocessorContext.setDryRun((Boolean)this.dryRun.get());
        preprocessorContext.setKeepAttributes((Boolean)this.keepAttributes.get());
        preprocessorContext.setKeepLines((Boolean)this.keepLines.get());
        preprocessorContext.setAllowWhitespaces((Boolean)this.allowWhitespaces.get());
        preprocessorContext.setExcludeExtensions((List)this.excludeExtensions.get());
        preprocessorContext.setExtensions((List)this.fileExtensions.get());
        preprocessorContext.setPreserveIndents((Boolean)this.preserveIndents.get());
        preprocessorContext.setSourceEncoding(Charset.forName((String)this.sourceEncoding.get()));
        preprocessorContext.setTargetEncoding(Charset.forName((String)this.targetEncoding.get()));
        preprocessorContext.setUnknownVariableAsFalse((Boolean)this.unknownVarAsFalse.get());
        preprocessorContext.setVerbose((Boolean)this.verbose.get());
        ((Map)this.vars.getOrElse(Collections.emptyMap())).forEach((key, value) -> {
            logger.debug(String.format("Registering global variable: %s=%s", key, value));
            preprocessorContext.setGlobalVariable((String)key, Value.recognizeRawString(value));
        });
        JcpPreprocessor preprocessor = new JcpPreprocessor(preprocessorContext);
        logger.debug("Preprocessing starting");
        preprocessor.execute();
        Set<File> foundAllGeneratedFiles = preprocessor.getContext().findAllProducedFiles();
        Set<File> foundAllInputFiles = preprocessor.getContext().findAllInputFiles();
        this.outcomingFiles.setFrom(foundAllGeneratedFiles);
        this.incomingFiles.setFrom(foundAllInputFiles);
    }
}

