/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.maven;

import com.igormaznitsa.jcp.JcpPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.maven.MavenPropertiesImporter;
import com.igormaznitsa.jcp.utils.GetUtils;
import hidden.jcp.org.apache.commons.text.StringEscapeUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="preprocess", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class PreprocessMojo
extends AbstractMojo
implements PreprocessorLogger {
    @Parameter(alias="compileSourceRoots", defaultValue="${project.compileSourceRoots}", required=true, readonly=true)
    private List<String> compileSourceRoots = new ArrayList<String>();
    @Parameter(alias="testCompileSourceRoots", defaultValue="${project.testCompileSourceRoots}", required=true, readonly=true)
    private List<String> testCompileSourceRoots = new ArrayList<String>();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(alias="sources")
    private List<String> sources = null;
    @Parameter(alias="eol", property="jcp.line.separator", defaultValue="${line.separator}")
    private String eol = null;
    @Parameter(alias="keepAttributes", defaultValue="false")
    private boolean keepAttributes = false;
    @Parameter(alias="target", defaultValue="${project.build.directory}${file.separator}generated-sources${file.separator}preprocessed")
    private File target = null;
    @Parameter(alias="targetTest", defaultValue="${project.build.directory}${file.separator}generated-test-sources${file.separator}preprocessed")
    private File targetTest = null;
    @Parameter(alias="sourceEncoding", defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding = StandardCharsets.UTF_8.name();
    @Parameter(alias="targetEncoding", defaultValue="${project.build.sourceEncoding}")
    private String targetEncoding = StandardCharsets.UTF_8.name();
    @Parameter(alias="ignoreMissingSources", defaultValue="false")
    private boolean ignoreMissingSources = false;
    @Parameter(alias="excludeExtensions")
    private List<String> excludeExtensions = Collections.singletonList("xml");
    @Parameter(alias="extensions")
    private List<String> extensions = new ArrayList<String>(Arrays.asList("java", "txt", "htm", "html"));
    @Parameter(alias="unknownVarAsFalse", defaultValue="false")
    private boolean unknownVarAsFalse = false;
    @Parameter(alias="dryRun", defaultValue="false")
    private boolean dryRun = false;
    @Parameter(alias="verbose", defaultValue="false")
    private boolean verbose = false;
    @Parameter(alias="clearTarget", defaultValue="false")
    private boolean clearTarget = false;
    @Parameter(alias="baseDir", defaultValue="${project.basedir}")
    private File baseDir = new File(".");
    @Parameter(alias="careForLastEol", defaultValue="false")
    private boolean careForLastEol = false;
    @Parameter(alias="replaceSources", defaultValue="true")
    private boolean replaceSources = true;
    @Parameter(alias="keepComments", defaultValue="true")
    private boolean keepComments = true;
    @Parameter(alias="vars")
    private Map<String, String> vars = new HashMap<String, String>();
    @Parameter(alias="excludeFolders")
    private List<String> excludeFolders = new ArrayList<String>();
    @Parameter(alias="configFiles")
    private List<String> configFiles = new ArrayList<String>();
    @Parameter(alias="keepLines", defaultValue="true")
    private boolean keepLines = true;
    @Parameter(alias="allowWhitespaces", defaultValue="false")
    private boolean allowWhitespaces = false;
    @Parameter(alias="preserveIndents", defaultValue="false")
    private boolean preserveIndents = false;
    @Parameter(alias="useTestSources", defaultValue="false")
    private boolean useTestSources = false;
    @Parameter(alias="skip", property="jcp.preprocess.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(alias="dontOverwriteSameContent", defaultValue="false")
    private boolean dontOverwriteSameContent = false;

    private List<String> formSourceRootList() {
        List<String> result = Collections.emptyList();
        if (this.getSources() == null) {
            if (this.project != null) {
                result = (this.isUseTestSources() ? this.testCompileSourceRoots : this.compileSourceRoots).stream().filter(Objects::nonNull).map(File::new).peek(x -> {
                    if (!x.isDirectory()) {
                        this.getLog().debug((CharSequence)String.format("Src.folder doesn't exist: %s", x));
                    }
                }).filter(x -> !this.isIgnoreMissingSources() || x.isDirectory()).map(File::getAbsolutePath).collect(Collectors.toList());
            }
        } else {
            result = new ArrayList<String>(this.getSources());
        }
        return result;
    }

    private void replaceSourceRootByPreprocessingDestinationFolder(PreprocessorContext context) throws IOException {
        if (this.project != null) {
            List<PreprocessorContext.SourceFolder> sourceFolders = context.getSources();
            List<String> sourceRoots = this.isUseTestSources() ? this.testCompileSourceRoots : this.compileSourceRoots;
            ArrayList<String> sourceRootsAsCanonical = new ArrayList<String>();
            for (String src : sourceRoots) {
                sourceRootsAsCanonical.add(new File(src).getCanonicalPath());
            }
            for (PreprocessorContext.SourceFolder folder : sourceFolders) {
                int index = sourceRoots.indexOf(folder.getAsString());
                if (index < 0) {
                    String canonicalPath = folder.getAsFile().getCanonicalPath();
                    index = sourceRootsAsCanonical.indexOf(canonicalPath);
                }
                if (index < 0) continue;
                this.info("Source root is removed from the source root list: " + sourceRoots.get(index));
                sourceRoots.remove(index);
            }
            String destinationDir = context.getTarget().getCanonicalPath();
            sourceRoots.add(destinationDir);
            this.info("Source root is enlisted: " + destinationDir);
        }
    }

    PreprocessorContext makePreprocessorContext() throws IOException {
        PreprocessorContext context = new PreprocessorContext(this.getBaseDir());
        context.setPreprocessorLogger(this);
        if (this.project != null) {
            MavenPropertiesImporter mavenPropertiesImporter = new MavenPropertiesImporter(context, this.project, this.session, this.isVerbose() || this.getLog().isDebugEnabled());
            context.registerSpecialVariableProcessor(mavenPropertiesImporter);
        }
        context.setSources(this.formSourceRootList());
        context.setTarget(this.isUseTestSources() ? this.getTargetTest() : this.getTarget());
        context.setSourceEncoding(Charset.forName(this.getSourceEncoding().trim()));
        context.setTargetEncoding(Charset.forName(this.getTargetEncoding().trim()));
        context.setExcludeFolders(this.getExcludeFolders());
        context.setExcludeExtensions(this.getExcludeExtensions());
        context.setExtensions(this.getExtensions());
        if (this.getEol() != null) {
            context.setEol(StringEscapeUtils.unescapeJava(this.getEol()));
        }
        this.info("Source folders: " + context.getSources().stream().map(PreprocessorContext.SourceFolder::getAsString).collect(Collectors.joining(File.pathSeparator)));
        this.info("Target folder: " + context.getTarget());
        context.setUnknownVariableAsFalse(this.isUnknownVarAsFalse());
        context.setDontOverwriteSameContent(this.isDontOverwriteSameContent());
        context.setClearTarget(this.isClearTarget());
        context.setCareForLastEol(this.isCareForLastEol());
        context.setKeepComments(this.isKeepComments());
        context.setVerbose(this.getLog().isDebugEnabled() || this.isVerbose());
        context.setKeepLines(this.isKeepLines());
        context.setDryRun(this.isDryRun());
        context.setAllowWhitespaces(this.isAllowWhitespaces());
        context.setPreserveIndents(this.isPreserveIndents());
        context.setExcludeFolders(this.getExcludeFolders());
        context.setKeepAttributes(this.isKeepAttributes());
        this.configFiles.forEach(x -> context.registerConfigFile(new File((String)x)));
        this.getVars().forEach((key, value) -> {
            this.getLog().debug((CharSequence)String.format("Register global var: '%s' <- '%s'", key, value));
            context.setGlobalVariable((String)key, Value.recognizeRawString(value));
        });
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        PreprocessorContext context;
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip preprocessing");
            return;
        }
        try {
            context = this.makePreprocessorContext();
        }
        catch (Exception ex) {
            PreprocessorException newException = PreprocessorException.extractPreprocessorException(ex);
            throw new MojoExecutionException(newException == null ? ex.getMessage() : newException.toString(), newException == null ? ex : newException);
        }
        if (context.getSources().isEmpty()) {
            if (!this.isIgnoreMissingSources()) throw new MojoFailureException("Source folders are not provided, check parameters and project type");
            this.getLog().warn((CharSequence)"Source folders are not provided, preprocessing is ignored.");
            return;
        }
        try {
            JcpPreprocessor preprocessor = new JcpPreprocessor(context);
            preprocessor.execute();
            if (!this.isReplaceSources()) return;
            this.replaceSourceRootByPreprocessingDestinationFolder(context);
            return;
        }
        catch (Exception ex) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(ex);
            throw new MojoFailureException(pp == null ? ex.getMessage() : PreprocessorException.referenceAsString('.', pp), (Throwable)(pp == null ? ex : pp));
        }
    }

    @Override
    public void error(String message) {
        this.getLog().error((CharSequence)GetUtils.ensureNonNull(message, "<null>"));
    }

    @Override
    public void info(String message) {
        this.getLog().info((CharSequence)GetUtils.ensureNonNull(message, "<null>"));
    }

    @Override
    public void warning(String message) {
        this.getLog().warn((CharSequence)GetUtils.ensureNonNull(message, "<null>"));
    }

    @Override
    public void debug(String message) {
        this.getLog().debug((CharSequence)GetUtils.ensureNonNull(message, "<null>"));
    }

    public List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    public List<String> getTestCompileSourceRoots() {
        return this.testCompileSourceRoots;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String getEol() {
        return this.eol;
    }

    public boolean isKeepAttributes() {
        return this.keepAttributes;
    }

    public File getTarget() {
        return this.target;
    }

    public File getTargetTest() {
        return this.targetTest;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public boolean isIgnoreMissingSources() {
        return this.ignoreMissingSources;
    }

    public List<String> getExcludeExtensions() {
        return this.excludeExtensions;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean isUnknownVarAsFalse() {
        return this.unknownVarAsFalse;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isClearTarget() {
        return this.clearTarget;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isCareForLastEol() {
        return this.careForLastEol;
    }

    public boolean isReplaceSources() {
        return this.replaceSources;
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public List<String> getExcludeFolders() {
        return this.excludeFolders;
    }

    public List<String> getConfigFiles() {
        return this.configFiles;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }

    public boolean isAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    public boolean isPreserveIndents() {
        return this.preserveIndents;
    }

    public boolean isUseTestSources() {
        return this.useTestSources;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isDontOverwriteSameContent() {
        return this.dontOverwriteSameContent;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public void setKeepAttributes(boolean keepAttributes) {
        this.keepAttributes = keepAttributes;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setTargetTest(File targetTest) {
        this.targetTest = targetTest;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public void setIgnoreMissingSources(boolean ignoreMissingSources) {
        this.ignoreMissingSources = ignoreMissingSources;
    }

    public void setExcludeExtensions(List<String> excludeExtensions) {
        this.excludeExtensions = excludeExtensions;
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public void setUnknownVarAsFalse(boolean unknownVarAsFalse) {
        this.unknownVarAsFalse = unknownVarAsFalse;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setClearTarget(boolean clearTarget) {
        this.clearTarget = clearTarget;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCareForLastEol(boolean careForLastEol) {
        this.careForLastEol = careForLastEol;
    }

    public void setReplaceSources(boolean replaceSources) {
        this.replaceSources = replaceSources;
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public void setExcludeFolders(List<String> excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public void setConfigFiles(List<String> configFiles) {
        this.configFiles = configFiles;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public void setAllowWhitespaces(boolean allowWhitespaces) {
        this.allowWhitespaces = allowWhitespaces;
    }

    public void setPreserveIndents(boolean preserveIndents) {
        this.preserveIndents = preserveIndents;
    }

    public void setUseTestSources(boolean useTestSources) {
        this.useTestSources = useTestSources;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setDontOverwriteSameContent(boolean dontOverwriteSameContent) {
        this.dontOverwriteSameContent = dontOverwriteSameContent;
    }

    public String toString() {
        return "PreprocessMojo(compileSourceRoots=" + this.getCompileSourceRoots() + ", testCompileSourceRoots=" + this.getTestCompileSourceRoots() + ", project=" + this.getProject() + ", session=" + this.getSession() + ", sources=" + this.getSources() + ", eol=" + this.getEol() + ", keepAttributes=" + this.isKeepAttributes() + ", target=" + this.getTarget() + ", targetTest=" + this.getTargetTest() + ", sourceEncoding=" + this.getSourceEncoding() + ", targetEncoding=" + this.getTargetEncoding() + ", ignoreMissingSources=" + this.isIgnoreMissingSources() + ", excludeExtensions=" + this.getExcludeExtensions() + ", extensions=" + this.getExtensions() + ", unknownVarAsFalse=" + this.isUnknownVarAsFalse() + ", dryRun=" + this.isDryRun() + ", verbose=" + this.isVerbose() + ", clearTarget=" + this.isClearTarget() + ", baseDir=" + this.getBaseDir() + ", careForLastEol=" + this.isCareForLastEol() + ", replaceSources=" + this.isReplaceSources() + ", keepComments=" + this.isKeepComments() + ", vars=" + this.getVars() + ", excludeFolders=" + this.getExcludeFolders() + ", configFiles=" + this.getConfigFiles() + ", keepLines=" + this.isKeepLines() + ", allowWhitespaces=" + this.isAllowWhitespaces() + ", preserveIndents=" + this.isPreserveIndents() + ", useTestSources=" + this.isUseTestSources() + ", skip=" + this.isSkip() + ", dontOverwriteSameContent=" + this.isDontOverwriteSameContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreprocessMojo)) {
            return false;
        }
        PreprocessMojo other = (PreprocessMojo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKeepAttributes() != other.isKeepAttributes()) {
            return false;
        }
        if (this.isIgnoreMissingSources() != other.isIgnoreMissingSources()) {
            return false;
        }
        if (this.isUnknownVarAsFalse() != other.isUnknownVarAsFalse()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isVerbose() != other.isVerbose()) {
            return false;
        }
        if (this.isClearTarget() != other.isClearTarget()) {
            return false;
        }
        if (this.isCareForLastEol() != other.isCareForLastEol()) {
            return false;
        }
        if (this.isReplaceSources() != other.isReplaceSources()) {
            return false;
        }
        if (this.isKeepComments() != other.isKeepComments()) {
            return false;
        }
        if (this.isKeepLines() != other.isKeepLines()) {
            return false;
        }
        if (this.isAllowWhitespaces() != other.isAllowWhitespaces()) {
            return false;
        }
        if (this.isPreserveIndents() != other.isPreserveIndents()) {
            return false;
        }
        if (this.isUseTestSources() != other.isUseTestSources()) {
            return false;
        }
        if (this.isSkip() != other.isSkip()) {
            return false;
        }
        if (this.isDontOverwriteSameContent() != other.isDontOverwriteSameContent()) {
            return false;
        }
        List<String> this$compileSourceRoots = this.getCompileSourceRoots();
        List<String> other$compileSourceRoots = other.getCompileSourceRoots();
        if (this$compileSourceRoots == null ? other$compileSourceRoots != null : !((Object)this$compileSourceRoots).equals(other$compileSourceRoots)) {
            return false;
        }
        List<String> this$testCompileSourceRoots = this.getTestCompileSourceRoots();
        List<String> other$testCompileSourceRoots = other.getTestCompileSourceRoots();
        if (this$testCompileSourceRoots == null ? other$testCompileSourceRoots != null : !((Object)this$testCompileSourceRoots).equals(other$testCompileSourceRoots)) {
            return false;
        }
        MavenProject this$project = this.getProject();
        MavenProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        MavenSession this$session = this.getSession();
        MavenSession other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        List<String> this$sources = this.getSources();
        List<String> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        String this$eol = this.getEol();
        String other$eol = other.getEol();
        if (this$eol == null ? other$eol != null : !this$eol.equals(other$eol)) {
            return false;
        }
        File this$target = this.getTarget();
        File other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        File this$targetTest = this.getTargetTest();
        File other$targetTest = other.getTargetTest();
        if (this$targetTest == null ? other$targetTest != null : !((Object)this$targetTest).equals(other$targetTest)) {
            return false;
        }
        String this$sourceEncoding = this.getSourceEncoding();
        String other$sourceEncoding = other.getSourceEncoding();
        if (this$sourceEncoding == null ? other$sourceEncoding != null : !this$sourceEncoding.equals(other$sourceEncoding)) {
            return false;
        }
        String this$targetEncoding = this.getTargetEncoding();
        String other$targetEncoding = other.getTargetEncoding();
        if (this$targetEncoding == null ? other$targetEncoding != null : !this$targetEncoding.equals(other$targetEncoding)) {
            return false;
        }
        List<String> this$excludeExtensions = this.getExcludeExtensions();
        List<String> other$excludeExtensions = other.getExcludeExtensions();
        if (this$excludeExtensions == null ? other$excludeExtensions != null : !((Object)this$excludeExtensions).equals(other$excludeExtensions)) {
            return false;
        }
        List<String> this$extensions = this.getExtensions();
        List<String> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        File this$baseDir = this.getBaseDir();
        File other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
            return false;
        }
        Map<String, String> this$vars = this.getVars();
        Map<String, String> other$vars = other.getVars();
        if (this$vars == null ? other$vars != null : !((Object)this$vars).equals(other$vars)) {
            return false;
        }
        List<String> this$excludeFolders = this.getExcludeFolders();
        List<String> other$excludeFolders = other.getExcludeFolders();
        if (this$excludeFolders == null ? other$excludeFolders != null : !((Object)this$excludeFolders).equals(other$excludeFolders)) {
            return false;
        }
        List<String> this$configFiles = this.getConfigFiles();
        List<String> other$configFiles = other.getConfigFiles();
        return !(this$configFiles == null ? other$configFiles != null : !((Object)this$configFiles).equals(other$configFiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreprocessMojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepAttributes() ? 79 : 97);
        result = result * 59 + (this.isIgnoreMissingSources() ? 79 : 97);
        result = result * 59 + (this.isUnknownVarAsFalse() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        result = result * 59 + (this.isClearTarget() ? 79 : 97);
        result = result * 59 + (this.isCareForLastEol() ? 79 : 97);
        result = result * 59 + (this.isReplaceSources() ? 79 : 97);
        result = result * 59 + (this.isKeepComments() ? 79 : 97);
        result = result * 59 + (this.isKeepLines() ? 79 : 97);
        result = result * 59 + (this.isAllowWhitespaces() ? 79 : 97);
        result = result * 59 + (this.isPreserveIndents() ? 79 : 97);
        result = result * 59 + (this.isUseTestSources() ? 79 : 97);
        result = result * 59 + (this.isSkip() ? 79 : 97);
        result = result * 59 + (this.isDontOverwriteSameContent() ? 79 : 97);
        List<String> $compileSourceRoots = this.getCompileSourceRoots();
        result = result * 59 + ($compileSourceRoots == null ? 43 : ((Object)$compileSourceRoots).hashCode());
        List<String> $testCompileSourceRoots = this.getTestCompileSourceRoots();
        result = result * 59 + ($testCompileSourceRoots == null ? 43 : ((Object)$testCompileSourceRoots).hashCode());
        MavenProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        MavenSession $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        List<String> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        String $eol = this.getEol();
        result = result * 59 + ($eol == null ? 43 : $eol.hashCode());
        File $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        File $targetTest = this.getTargetTest();
        result = result * 59 + ($targetTest == null ? 43 : ((Object)$targetTest).hashCode());
        String $sourceEncoding = this.getSourceEncoding();
        result = result * 59 + ($sourceEncoding == null ? 43 : $sourceEncoding.hashCode());
        String $targetEncoding = this.getTargetEncoding();
        result = result * 59 + ($targetEncoding == null ? 43 : $targetEncoding.hashCode());
        List<String> $excludeExtensions = this.getExcludeExtensions();
        result = result * 59 + ($excludeExtensions == null ? 43 : ((Object)$excludeExtensions).hashCode());
        List<String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        File $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
        Map<String, String> $vars = this.getVars();
        result = result * 59 + ($vars == null ? 43 : ((Object)$vars).hashCode());
        List<String> $excludeFolders = this.getExcludeFolders();
        result = result * 59 + ($excludeFolders == null ? 43 : ((Object)$excludeFolders).hashCode());
        List<String> $configFiles = this.getConfigFiles();
        result = result * 59 + ($configFiles == null ? 43 : ((Object)$configFiles).hashCode());
        return result;
    }
}

