/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.utils;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import hidden.jcp.org.apache.commons.io.FileUtils;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PreprocessorUtils {
    private static final Pattern PATTERN_MACROS_WITH_SPACES = Pattern.compile("\\/\\*\\s*\\$(.*?)\\$\\s*\\*\\/");

    private PreprocessorUtils() {
    }

    public static Optional<FileInfoContainer> findFirstActiveFileContainer(PreprocessorContext context) {
        Optional<FileInfoContainer> result = context.getPreprocessingState().getCurrentIncludeStack().stream().map(TextFileDataContainer::getFile).map(x -> context.findFileInfoContainer((File)x).orElse(null)).filter(Objects::nonNull).findFirst();
        return result.isPresent() ? result : Optional.ofNullable(context.getPreprocessingState().getRootFileInfo());
    }

    public static String getFileExtension(File file) {
        String result = null;
        if (file != null) {
            result = FilenameUtils.getExtension(file.getName());
        }
        return result;
    }

    public static BufferedReader makeFileReader(File file, Charset charset, int bufferSize) throws IOException {
        Objects.requireNonNull(file, "File is null");
        Objects.requireNonNull(charset, "Charset is null");
        BufferedReader result = bufferSize <= 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset), bufferSize);
        return result;
    }

    public static String[] replaceChar(String[] source, char toBeReplaced, char replacement) {
        String[] result = new String[source.length];
        int index = 0;
        for (String curStr : source) {
            result[index++] = curStr.replace(toBeReplaced, replacement);
        }
        return result;
    }

    public static String extractTrimmedTail(String prefix, String value) {
        return PreprocessorUtils.extractTail(prefix, value).trim();
    }

    public static String extractTail(String prefix, String value) {
        Objects.requireNonNull(prefix, "Prefix is null");
        Objects.requireNonNull(value, "Value is null");
        if (prefix.length() > value.length()) {
            throw new IllegalArgumentException("Prefix is too long");
        }
        return value.substring(prefix.length());
    }

    public static void copyFile(File source, File dest, boolean copyFileAttributes) throws IOException {
        Objects.requireNonNull(source, "Source is null");
        Objects.requireNonNull(dest, "Destination file is null");
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source file is directory");
        }
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("Can't make directory [" + PreprocessorUtils.getFilePath(dest.getParentFile()) + ']');
        }
        FileUtils.copyFile(source, dest);
        if (copyFileAttributes) {
            PreprocessorUtils.copyFileAttributes(source, dest);
        }
    }

    public static boolean copyFileAttributes(File from, File to) {
        boolean result = to.setExecutable(from.canExecute());
        result = result && to.setReadable(from.canRead());
        result = result && to.setWritable(from.canWrite());
        result = result && to.setLastModified(from.lastModified());
        return result;
    }

    public static String replacePartByChar(String text, char chr, int startPosition, int length) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("Start position must be great or equal zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must be great or equal zero");
        }
        StringBuilder result = new StringBuilder(text.length());
        result.append(text.subSequence(0, Math.min(text.length(), startPosition)));
        for (int i = startPosition; i < Math.min(text.length(), startPosition + length); ++i) {
            result.append(chr);
        }
        result.append(text.subSequence(Math.min(startPosition + length, text.length()), text.length()));
        return result.toString();
    }

    public static String generateStringForChar(char chr, int length) {
        StringBuilder buffer = new StringBuilder(Math.max(length, 1));
        for (int i = 0; i < length; ++i) {
            buffer.append(chr);
        }
        return buffer.toString();
    }

    public static String processMacroses(String processingString, PreprocessorContext context) {
        String result = processingString;
        if (context.isAllowWhitespaces()) {
            Matcher matcher = PATTERN_MACROS_WITH_SPACES.matcher(processingString);
            StringBuilder buffer = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                int start = matcher.start();
                int prevEnd = end;
                end = matcher.end();
                String macrosBody = matcher.group(1);
                Value value = Expression.evalExpression(macrosBody, context);
                buffer.append(processingString, prevEnd, start);
                buffer.append(value.toString());
            }
            if (end < processingString.length()) {
                buffer.append(processingString.substring(end));
            }
            result = buffer.toString();
        } else {
            int position;
            while (!Thread.currentThread().isInterrupted() && (position = result.indexOf("/*$")) >= 0) {
                String leftPart = result.substring(0, position);
                int beginIndex = position;
                if ((position = result.indexOf("$*/", position)) < 0) break;
                String macrosBody = result.substring(beginIndex + 3, position);
                String rightPart = result.substring(position + 3);
                Value value = Expression.evalExpression(macrosBody, context);
                result = leftPart + value.toString() + rightPart;
            }
        }
        return result;
    }

    private static void checkFile(File file) throws IOException {
        Objects.requireNonNull(file, "File is null");
        if (!file.isFile()) {
            throw new FileNotFoundException("File " + PreprocessorUtils.getFilePath(file) + " doesn't exist");
        }
    }

    public static String[] readWholeTextFileIntoArray(File file, Charset encoding, AtomicBoolean endedByNextLine) throws IOException {
        PreprocessorUtils.checkFile(file);
        ArrayList<String> strContainer = new ArrayList<String>(1024);
        try (BufferedReader srcBufferedReader = PreprocessorUtils.makeFileReader(file, encoding == null ? StandardCharsets.UTF_8 : encoding, (int)file.length());){
            int chr;
            StringBuilder buffer = new StringBuilder();
            boolean stringEndedByNextLine = false;
            boolean meetCR = false;
            block9: while (!Thread.currentThread().isInterrupted() && (chr = srcBufferedReader.read()) >= 0) {
                switch (chr) {
                    case 10: {
                        stringEndedByNextLine = true;
                        strContainer.add(buffer.toString());
                        buffer.setLength(0);
                        meetCR = false;
                        continue block9;
                    }
                    case 13: {
                        if (meetCR) {
                            buffer.append((char)chr);
                            continue block9;
                        }
                        stringEndedByNextLine = false;
                        meetCR = true;
                        continue block9;
                    }
                }
                if (meetCR) {
                    buffer.append('\r');
                }
                meetCR = false;
                stringEndedByNextLine = false;
                buffer.append((char)chr);
            }
            if (buffer.length() != 0) {
                strContainer.add(buffer.toString());
                buffer.setLength(0);
            }
            if (endedByNextLine != null) {
                endedByNextLine.set(stringEndedByNextLine);
            }
        }
        return strContainer.toArray(new String[0]);
    }

    public static String[] splitForEqualChar(String string) {
        String[] result;
        int index = string.indexOf(61);
        if (index < 0) {
            result = new String[]{string};
        } else {
            String leftPart = string.substring(0, index).trim();
            String rightPart = string.substring(index + 1).trim();
            result = new String[]{leftPart, rightPart};
        }
        return result;
    }

    public static List<String> splitForCharAndHoldEmptyLine(String string, char delimiter) {
        List<String> result = PreprocessorUtils.splitForChar(string, delimiter);
        if (result.isEmpty()) {
            result.add("");
        }
        return result;
    }

    public static List<String> splitForChar(String string, char delimiter) {
        char[] array = string.toCharArray();
        StringBuilder buffer = new StringBuilder(array.length >> 1 == 0 ? 1 : array.length >> 1);
        ArrayList<String> tokens = new ArrayList<String>(10);
        for (char curChar : array) {
            if (curChar == delimiter) {
                if (buffer.length() == 0) continue;
                tokens.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(curChar);
        }
        if (buffer.length() != 0) {
            tokens.add(buffer.toString());
        }
        return tokens;
    }

    public static String normalizeVariableName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim().toLowerCase(Locale.ENGLISH);
    }

    public static String getFilePath(File file) {
        String result = "";
        if (file != null) {
            try {
                result = file.getCanonicalPath();
            }
            catch (IOException ex) {
                result = file.getAbsolutePath();
            }
        }
        return result;
    }

    public static void throwPreprocessorException(String msg, String processingString, File srcFile, int nextStringIndex, Throwable cause) {
        throw new PreprocessorException(msg, processingString, new FilePositionInfo[]{new FilePositionInfo(srcFile, nextStringIndex)}, cause);
    }

    public static String[] replaceStringPrefix(String[] allowedPrefixesToBeReplaced, String replacement, String[] strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            String detectedPrefix = null;
            for (String prefix : allowedPrefixesToBeReplaced) {
                if (!str.startsWith(prefix) || detectedPrefix != null && detectedPrefix.length() >= prefix.length()) continue;
                detectedPrefix = prefix;
            }
            result[i] = detectedPrefix != null ? replacement + str.substring(detectedPrefix.length()) : str;
        }
        return result;
    }

    public static String getNextLineCodes() {
        return System.getProperty("line.separator", "\r\n");
    }

    public static String leftTrim(String rawString) {
        char ch;
        int firstNonSpace = 0;
        for (int i = 0; i < rawString.length() && (ch = rawString.charAt(i)) <= ' '; ++i) {
            ++firstNonSpace;
        }
        return rawString.substring(firstNonSpace);
    }

    public static boolean isFileContentEquals(File src, File dst) throws IOException {
        if (src == null && dst == null) {
            return true;
        }
        if (src == null || dst == null) {
            return false;
        }
        if (src.isDirectory() && dst.isDirectory()) {
            return true;
        }
        if (src.isDirectory() || dst.isDirectory()) {
            return false;
        }
        if (src.length() != dst.length()) {
            return false;
        }
        return FileUtils.contentEquals(src, dst);
    }
}

