/*
 * Decompiled with CFR 0.152.
 */
package hidden.jcp.org.apache.bcel.generic;

import hidden.jcp.org.apache.bcel.ExceptionConstants;
import hidden.jcp.org.apache.bcel.classfile.ConstantPool;
import hidden.jcp.org.apache.bcel.generic.AllocationInstruction;
import hidden.jcp.org.apache.bcel.generic.ArrayType;
import hidden.jcp.org.apache.bcel.generic.CPInstruction;
import hidden.jcp.org.apache.bcel.generic.ClassGenException;
import hidden.jcp.org.apache.bcel.generic.ConstantPoolGen;
import hidden.jcp.org.apache.bcel.generic.ExceptionThrower;
import hidden.jcp.org.apache.bcel.generic.LoadClass;
import hidden.jcp.org.apache.bcel.generic.ObjectType;
import hidden.jcp.org.apache.bcel.generic.Type;
import hidden.jcp.org.apache.bcel.generic.Visitor;
import hidden.jcp.org.apache.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int index, short dimensions) {
        super((short)197, index);
        if (dimensions < 1) {
            throw new ClassGenException("Invalid dimensions value: " + dimensions);
        }
        this.dimensions = dimensions;
        this.length = (short)4;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeShort(this.index);
        out.writeByte(this.dimensions);
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.dimensions = bytes.readByte();
        this.length = (short)4;
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.index + " " + this.dimensions;
    }

    public String toString(ConstantPool cp) {
        return super.toString(cp) + " " + this.dimensions;
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] cs = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, cs, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return cs;
    }

    public ObjectType getLoadClassType(ConstantPoolGen cpg) {
        Type t = this.getType(cpg);
        if (t instanceof ArrayType) {
            t = ((ArrayType)t).getBasicType();
        }
        return t instanceof ObjectType ? (ObjectType)t : null;
    }

    public void accept(Visitor v) {
        v.visitLoadClass(this);
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitMULTIANEWARRAY(this);
    }
}

