/*
 * Decompiled with CFR 0.152.
 */
package hidden.jcp.org.apache.xalan.xsltc.compiler;

import hidden.jcp.org.apache.bcel.generic.BranchHandle;
import hidden.jcp.org.apache.bcel.generic.GOTO;
import hidden.jcp.org.apache.bcel.generic.InstructionHandle;
import hidden.jcp.org.apache.bcel.generic.InstructionList;
import hidden.jcp.org.apache.xalan.xsltc.compiler.CastExpr;
import hidden.jcp.org.apache.xalan.xsltc.compiler.Expression;
import hidden.jcp.org.apache.xalan.xsltc.compiler.NotCall;
import hidden.jcp.org.apache.xalan.xsltc.compiler.Parser;
import hidden.jcp.org.apache.xalan.xsltc.compiler.SymbolTable;
import hidden.jcp.org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import hidden.jcp.org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import hidden.jcp.org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import hidden.jcp.org.apache.xalan.xsltc.compiler.util.MethodType;
import hidden.jcp.org.apache.xalan.xsltc.compiler.util.Type;
import hidden.jcp.org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class LogicalExpr
extends Expression {
    public static final int OR = 0;
    public static final int AND = 1;
    private final int _op;
    private Expression _left;
    private Expression _right;
    private static final String[] Ops = new String[]{"or", "and"};

    public LogicalExpr(int op, Expression left, Expression right) {
        this._op = op;
        this._left = left;
        this._left.setParent(this);
        this._right = right;
        this._right.setParent(this);
    }

    public boolean hasPositionCall() {
        return this._left.hasPositionCall() || this._right.hasPositionCall();
    }

    public boolean hasLastCall() {
        return this._left.hasLastCall() || this._right.hasLastCall();
    }

    public Object evaluateAtCompileTime() {
        Object leftb = this._left.evaluateAtCompileTime();
        Object rightb = this._right.evaluateAtCompileTime();
        if (leftb == null || rightb == null) {
            return null;
        }
        if (this._op == 1) {
            return leftb == Boolean.TRUE && rightb == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE;
        }
        return leftb == Boolean.TRUE || rightb == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE;
    }

    public int getOp() {
        return this._op;
    }

    public void setParser(Parser parser) {
        super.setParser(parser);
        this._left.setParser(parser);
        this._right.setParser(parser);
    }

    public String toString() {
        return Ops[this._op] + '(' + this._left + ", " + this._right + ')';
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type tright;
        Type tleft = this._left.typeCheck(stable);
        MethodType wantType = new MethodType(Type.Void, tleft, tright = this._right.typeCheck(stable));
        MethodType haveType = this.lookupPrimop(stable, Ops[this._op], wantType);
        if (haveType != null) {
            Type arg2;
            Type arg1 = (Type)haveType.argsType().elementAt(0);
            if (!arg1.identicalTo(tleft)) {
                this._left = new CastExpr(this._left, arg1);
            }
            if (!(arg2 = (Type)haveType.argsType().elementAt(1)).identicalTo(tright)) {
                this._right = new CastExpr(this._right, arg1);
            }
            this._type = haveType.resultType();
            return this._type;
        }
        throw new TypeCheckError(this);
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        this.translateDesynthesized(classGen, methodGen);
        this.synthesize(classGen, methodGen);
    }

    public void translateDesynthesized(ClassGenerator classGen, MethodGenerator methodGen) {
        InstructionList il = methodGen.getInstructionList();
        SyntaxTreeNode parent = this.getParent();
        if (this._op == 1) {
            this._left.translateDesynthesized(classGen, methodGen);
            InstructionHandle middle = il.append(NOP);
            this._right.translateDesynthesized(classGen, methodGen);
            InstructionHandle after = il.append(NOP);
            this._falseList.append(this._right._falseList.append(this._left._falseList));
            if (this._left instanceof LogicalExpr && ((LogicalExpr)this._left).getOp() == 0) {
                this._left.backPatchTrueList(middle);
            } else if (this._left instanceof NotCall) {
                this._left.backPatchTrueList(middle);
            } else {
                this._trueList.append(this._left._trueList);
            }
            if (this._right instanceof LogicalExpr && ((LogicalExpr)this._right).getOp() == 0) {
                this._right.backPatchTrueList(after);
            } else if (this._right instanceof NotCall) {
                this._right.backPatchTrueList(after);
            } else {
                this._trueList.append(this._right._trueList);
            }
        } else {
            this._left.translateDesynthesized(classGen, methodGen);
            BranchHandle ih = il.append(new GOTO(null));
            this._right.translateDesynthesized(classGen, methodGen);
            this._left._trueList.backPatch(ih);
            this._left._falseList.backPatch(ih.getNext());
            this._falseList.append(this._right._falseList);
            this._trueList.add(ih).append(this._right._trueList);
        }
    }
}

