/*
 * Decompiled with CFR 0.152.
 */
package hidden.jcp.org.apache.xpath.patterns;

import hidden.jcp.javax.xml.transform.TransformerException;
import hidden.jcp.org.apache.xpath.Expression;
import hidden.jcp.org.apache.xpath.ExpressionOwner;
import hidden.jcp.org.apache.xpath.XPathContext;
import hidden.jcp.org.apache.xpath.XPathVisitor;
import hidden.jcp.org.apache.xpath.objects.XObject;
import hidden.jcp.org.apache.xpath.patterns.NodeTest;
import hidden.jcp.org.apache.xpath.patterns.StepPattern;
import java.util.Vector;

public class UnionPattern
extends Expression {
    static final long serialVersionUID = -6670449967116905820L;
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vars, int globalsSize) {
        for (int i = 0; i < this.m_patterns.length; ++i) {
            this.m_patterns[i].fixupVariables(vars, globalsSize);
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            for (int i = 0; i < n; ++i) {
                if (!this.m_patterns[i].canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (null != patterns) {
            for (int i = 0; i < patterns.length; ++i) {
                patterns[i].exprSetParent(this);
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        int n = this.m_patterns.length;
        for (int i = 0; i < n; ++i) {
            XObject score = this.m_patterns[i].execute(xctxt);
            if (score == NodeTest.SCORE_NONE) continue;
            if (null == bestScore) {
                bestScore = score;
                continue;
            }
            if (!(score.num() > bestScore.num())) continue;
            bestScore = score;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitUnionPattern(owner, this);
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            for (int i = 0; i < n; ++i) {
                this.m_patterns[i].callVisitors(new UnionPathPartOwner(i), visitor);
            }
        }
    }

    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == up.m_patterns || up.m_patterns.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_patterns[i].deepEquals(up.m_patterns[i])) continue;
                return false;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int index) {
            this.m_index = index;
        }

        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)exp;
        }
    }
}

