/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.util.Locale;

public class ExcludeFoldersHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/ED:";

    @Override
    public String getDescription() {
        return "folders to be excluded from preprocessing, ANT matcher format allowed. Use system path separator as delimiter.";
    }

    @Override
    public boolean processCommandLineKey(String key, PreprocessorContext context) {
        String tail;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(tail = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setExcludeFolders(PreprocessorUtils.splitForChar(tail, File.pathSeparatorChar));
            result = true;
        }
        return result;
    }

    @Override
    public String getKeyName() {
        return ARG_NAME;
    }
}

