/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.CommentRemoverType;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.util.Locale;

public class KeepCommentsHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/M:";

    @Override
    public String getDescription() {
        return "select keep comments mode, for instance /M:remove_c_style, (allowed: true,false," + CommentRemoverType.makeListOfAllRemoverIds() + ')';
    }

    @Override
    public boolean processCommandLineKey(String key, PreprocessorContext context) {
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME)) {
            CommentRemoverType mode;
            String tail = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key);
            try {
                mode = PreprocessorUtils.findCommentRemoverForId(tail);
            }
            catch (IllegalArgumentException ex) {
                throw context.makeException("Illegal keep comments mode '" + tail + "' in " + ARG_NAME + ", expected one of: true,false," + CommentRemoverType.makeListOfAllRemoverIds(), null);
            }
            context.setKeepComments(mode);
            result = true;
        }
        return result;
    }

    @Override
    public String getKeyName() {
        return ARG_NAME;
    }
}

