/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SourceDirectoryHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/I:";

    @Override
    public String getDescription() {
        return "define the source folder for preprocessing (by default " + PreprocessorContext.DEFAULT_SOURCE_DIRECTORY + ')';
    }

    @Override
    public boolean processCommandLineKey(String key, PreprocessorContext context) {
        String tail;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(tail = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setSources(Arrays.stream(PreprocessorUtils.extractTail(ARG_NAME, key).split(Pattern.quote(File.pathSeparator))).map(String::trim).collect(Collectors.toList()));
            result = true;
        }
        return result;
    }

    @Override
    public String getKeyName() {
        return ARG_NAME;
    }
}

