/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.InfoHelper;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JCPSpecialVariableProcessor
implements SpecialVariableProcessor {
    public static final String VAR_DEST_DIR = "jcp.dst.dir";
    public static final String VAR_VERSION = "jcp.version";
    public static final String VAR_DEST_FILE_NAME = "jcp.dst.name";
    public static final String VAR_DEST_FULLPATH = "jcp.dst.path";
    public static final String VAR_SRC_FILE_NAME = "jcp.src.name";
    public static final String VAR_SRC_FILE_NAME2 = "__filename__";
    public static final String VAR_SRC_DIR = "jcp.src.dir";
    public static final String VAR_SRC_DIR2 = "__filefolder__";
    public static final String VAR_SRC_FULLPATH = "jcp.src.path";
    public static final String VAR_SRC_FULLPATH2 = "__file__";
    public static final String VAR_LINE = "__line__";
    public static final String VAR_DATE = "__date__";
    public static final String VAR_TIME = "__time__";
    public static final String VAR_TIMESTAMP = "__timestamp__";
    final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy");
    final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    final SimpleDateFormat timestampFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");

    public static List<NameReferencePair> getReference() {
        ArrayList<NameReferencePair> result = new ArrayList<NameReferencePair>();
        result.add(new NameReferencePair(VAR_VERSION, "Preprocessor version"));
        result.add(new NameReferencePair(VAR_SRC_FULLPATH, "Full path to preprocessing file, read only"));
        result.add(new NameReferencePair(VAR_SRC_FULLPATH2, "Synonym for 'jcp.src.path', read only"));
        result.add(new NameReferencePair(VAR_SRC_DIR, "Preprocessing file folder, read only"));
        result.add(new NameReferencePair(VAR_SRC_DIR2, "Synonym for 'jcp.src.dir', read only"));
        result.add(new NameReferencePair(VAR_SRC_FILE_NAME, "Preprocessing file name, read only"));
        result.add(new NameReferencePair(VAR_SRC_FILE_NAME2, "Synonym for 'jcp.src.name', read only"));
        result.add(new NameReferencePair(VAR_LINE, "Number of preprocessing line, read only"));
        result.add(new NameReferencePair(VAR_DEST_FULLPATH, "Full destination file path, read only"));
        result.add(new NameReferencePair(VAR_DEST_DIR, "Destination folder, read-write"));
        result.add(new NameReferencePair(VAR_DEST_FILE_NAME, "Destination file name, read-write"));
        result.add(new NameReferencePair(VAR_TIME, "Time (HH:mm:ss)"));
        result.add(new NameReferencePair(VAR_DATE, "Date (MMM dd yyyy)"));
        result.add(new NameReferencePair(VAR_TIMESTAMP, "Source file timestamp (EEE MMM dd HH:mm:ss yyyy)"));
        return result;
    }

    @Override
    public String[] getVariableNames() {
        return new String[]{VAR_DEST_DIR, VAR_DEST_FILE_NAME, VAR_DEST_FULLPATH, VAR_SRC_DIR, VAR_SRC_DIR2, VAR_SRC_FILE_NAME, VAR_SRC_FILE_NAME2, VAR_SRC_FULLPATH, VAR_SRC_FULLPATH2, VAR_VERSION, VAR_LINE, VAR_TIME, VAR_TIMESTAMP, VAR_DATE};
    }

    @Override
    public Value getVariable(String varName, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        switch (varName) {
            case "jcp.dst.dir": {
                return Value.valueOf(state.getRootFileInfo().getTargetFolder());
            }
            case "jcp.dst.name": {
                return Value.valueOf(state.getRootFileInfo().getTargetFileName());
            }
            case "jcp.dst.path": {
                return Value.valueOf(state.getRootFileInfo().makeTargetFilePathAsString());
            }
            case "jcp.src.dir": 
            case "__filefolder__": {
                return Value.valueOf(state.getRootFileInfo().getSourceFile().getParent());
            }
            case "jcp.src.name": 
            case "__filename__": {
                return Value.valueOf(state.getRootFileInfo().getSourceFile().getName());
            }
            case "jcp.src.path": 
            case "__file__": {
                return Value.valueOf(PreprocessorUtils.getFilePath(state.getRootFileInfo().getSourceFile()));
            }
            case "jcp.version": {
                return Value.valueOf(InfoHelper.getVersion());
            }
            case "__time__": {
                return Value.valueOf(this.timeFormat.format(new Date()));
            }
            case "__date__": {
                return Value.valueOf(this.dateFormat.format(new Date()));
            }
            case "__timestamp__": {
                TextFileDataContainer filedata = state.peekFile();
                Value result = filedata == null ? Value.valueOf("<no file>") : Value.valueOf(this.timestampFormat.format(new Date(filedata.getFile().lastModified())));
                return result;
            }
            case "__line__": {
                TextFileDataContainer currentFile = state.peekFile();
                long line = currentFile == null ? -1L : (long)(currentFile.getLastReadStringIndex() + 1);
                return Value.valueOf(line);
            }
        }
        String text = "Attempting to read unexpected special variable [" + varName + ']';
        throw context.makeException(text, null);
    }

    @Override
    public void setVariable(String varName, Value value, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        switch (varName) {
            case "jcp.dst.dir": {
                if (value.getType() != ValueType.STRING) {
                    throw new IllegalArgumentException("Only STRING type allowed");
                }
                state.getRootFileInfo().setTargetFolder(value.asString());
                break;
            }
            case "jcp.dst.name": {
                if (value.getType() != ValueType.STRING) {
                    throw new IllegalArgumentException("Only STRING type allowed");
                }
                state.getRootFileInfo().setTargetFileName(value.asString());
                break;
            }
            case "jcp.dst.path": 
            case "jcp.src.dir": 
            case "__filefolder__": 
            case "jcp.src.name": 
            case "__filename__": 
            case "jcp.src.path": 
            case "__file__": 
            case "jcp.version": 
            case "__line__": 
            case "__time__": 
            case "__timestamp__": 
            case "__date__": {
                String text = "The variable '" + varName + "' can't be set directly";
                throw context.makeException(text, null);
            }
            default: {
                String text = "Attempting to write unexpected special variable [" + varName + ']';
                throw context.makeException(text, null);
            }
        }
    }

    public static final class NameReferencePair {
        private final String name;
        private final String reference;

        private NameReferencePair(String name, String reference) {
            this.name = name;
            this.reference = reference;
        }

        public String getName() {
            return this.name;
        }

        public String getReference() {
            return this.reference;
        }
    }
}

