/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbortDirectiveHandler;
import com.igormaznitsa.jcp.directives.ActionDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.BreakDirectiveHandler;
import com.igormaznitsa.jcp.directives.CommentNextLineDirectiveHandler;
import com.igormaznitsa.jcp.directives.ContinueDirectiveHandler;
import com.igormaznitsa.jcp.directives.DefineDirectiveHandler;
import com.igormaznitsa.jcp.directives.DefinelDirectiveHandler;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.directives.EchoDirectiveHandler;
import com.igormaznitsa.jcp.directives.ElseDirectiveHandler;
import com.igormaznitsa.jcp.directives.EndDirectiveHandler;
import com.igormaznitsa.jcp.directives.EndIfDirectiveHandler;
import com.igormaznitsa.jcp.directives.ErrorDirectiveHandler;
import com.igormaznitsa.jcp.directives.ExcludeIfDirectiveHandler;
import com.igormaznitsa.jcp.directives.ExitDirectiveHandler;
import com.igormaznitsa.jcp.directives.ExitIfDirectiveHandler;
import com.igormaznitsa.jcp.directives.FlushDirectiveHandler;
import com.igormaznitsa.jcp.directives.GlobalDirectiveHandler;
import com.igormaznitsa.jcp.directives.GlobalElseDirectiveHandler;
import com.igormaznitsa.jcp.directives.GlobalEndIfDirectiveHandler;
import com.igormaznitsa.jcp.directives.GlobalIfDirectiveHandler;
import com.igormaznitsa.jcp.directives.IfDefDirectiveHandler;
import com.igormaznitsa.jcp.directives.IfDefinedDirectiveHandler;
import com.igormaznitsa.jcp.directives.IfDirectiveHandler;
import com.igormaznitsa.jcp.directives.IfNDefDirectiveHandler;
import com.igormaznitsa.jcp.directives.IncludeDirectiveHandler;
import com.igormaznitsa.jcp.directives.LocalDirectiveHandler;
import com.igormaznitsa.jcp.directives.MsgDirectiveHandler;
import com.igormaznitsa.jcp.directives.NoAutoFlushHandler;
import com.igormaznitsa.jcp.directives.OutDisabledDirectiveHandler;
import com.igormaznitsa.jcp.directives.OutEnabledDirectiveHandler;
import com.igormaznitsa.jcp.directives.OutNameDirectiveHandler;
import com.igormaznitsa.jcp.directives.OutdirDirectiveHandler;
import com.igormaznitsa.jcp.directives.PostfixDirectiveHandler;
import com.igormaznitsa.jcp.directives.PrefixDirectiveHandler;
import com.igormaznitsa.jcp.directives.UndefDirectiveHandler;
import com.igormaznitsa.jcp.directives.WarningDirectiveHandler;
import com.igormaznitsa.jcp.directives.WhileDirectiveHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDirectiveHandler {
    public static final String DIRECTIVE_PREFIX = "//#";
    public static final String PREFIX_FOR_KEEPING_LINES = "//JCP> ";
    public static final String PREFIX_FOR_KEEPING_LINES_PROCESSED_DIRECTIVES = "//JCP! ";
    public static final String ONE_LINE_COMMENT = "//";

    public static List<AbstractDirectiveHandler> findAllDirectives() {
        ArrayList<AbstractDirectiveHandler> result = new ArrayList<AbstractDirectiveHandler>();
        result.add(new LocalDirectiveHandler());
        result.add(new IfDefinedDirectiveHandler());
        result.add(new IfNDefDirectiveHandler());
        result.add(new IfDefDirectiveHandler());
        result.add(new IfDirectiveHandler());
        result.add(new ElseDirectiveHandler());
        result.add(new EndIfDirectiveHandler());
        result.add(new WhileDirectiveHandler());
        result.add(new BreakDirectiveHandler());
        result.add(new ContinueDirectiveHandler());
        result.add(new EndDirectiveHandler());
        result.add(new ExitIfDirectiveHandler());
        result.add(new ExitDirectiveHandler());
        result.add(new OutdirDirectiveHandler());
        result.add(new OutEnabledDirectiveHandler());
        result.add(new OutNameDirectiveHandler());
        result.add(new OutDisabledDirectiveHandler());
        result.add(new CommentNextLineDirectiveHandler());
        result.add(new DefinelDirectiveHandler());
        result.add(new DefineDirectiveHandler());
        result.add(new UndefDirectiveHandler());
        result.add(new FlushDirectiveHandler());
        result.add(new IncludeDirectiveHandler());
        result.add(new ActionDirectiveHandler());
        result.add(new PostfixDirectiveHandler());
        result.add(new PrefixDirectiveHandler());
        result.add(new GlobalDirectiveHandler());
        result.add(new GlobalElseDirectiveHandler());
        result.add(new GlobalEndIfDirectiveHandler());
        result.add(new GlobalIfDirectiveHandler());
        result.add(new ExcludeIfDirectiveHandler());
        result.add(new ErrorDirectiveHandler());
        result.add(new WarningDirectiveHandler());
        result.add(new EchoDirectiveHandler());
        result.add(new MsgDirectiveHandler());
        result.add(new NoAutoFlushHandler());
        result.add(new AbortDirectiveHandler());
        return result;
    }

    public abstract String getName();

    public abstract String getReference();

    public String getFullName() {
        return DIRECTIVE_PREFIX + this.getName();
    }

    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.NONE;
    }

    public abstract AfterDirectiveProcessingBehaviour execute(String var1, PreprocessorContext var2);

    public boolean executeOnlyWhenExecutionAllowed() {
        return true;
    }

    public boolean isGlobalPhaseAllowed() {
        return false;
    }

    public boolean isPreprocessingPhaseAllowed() {
        return true;
    }

    public boolean isDeprecated() {
        return false;
    }
}

