/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import java.util.Objects;

public class ContinueDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "continue";
    }

    @Override
    public String getReference() {
        return "immediately jump to the next iteration of //#while";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isWhileStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "while", null);
        }
        TextFileDataContainer whileContainer = Objects.requireNonNull(state.peekWhile());
        state.popAllIFUntilContainerWithFile(whileContainer);
        state.popWhile();
        state.goToString(whileContainer.getNextStringIndex());
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

