/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import java.util.Objects;

public class EndDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "end";
    }

    @Override
    public String getReference() {
        return "end of //#while..." + this.getFullName() + " loop, start the next iteration";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isWhileStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "while", null);
        }
        if (state.isDirectiveCanBeProcessedIgnoreBreak()) {
            TextFileDataContainer thisWhile = Objects.requireNonNull(state.peekWhile(), "'WHILE' stack is empty!");
            boolean breakIsSet = state.getPreprocessingFlags().contains((Object)PreprocessingFlag.BREAK_COMMAND);
            state.popWhile();
            if (!breakIsSet) {
                state.goToString(thisWhile.getNextStringIndex());
            }
        } else {
            state.popWhile();
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }
}

