/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;

public class ExitIfDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "exitif";
    }

    @Override
    public String getReference() {
        return "conditionally end current file preprocessing, return to the calling file if presented";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.BOOLEAN;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        AfterDirectiveProcessingBehaviour result = AfterDirectiveProcessingBehaviour.PROCESSED;
        Value condition = Expression.evalExpression(string, context);
        if (condition.getType() != ValueType.BOOLEAN) {
            throw context.makeException(this.getFullName() + " needs boolean argument", null);
        }
        if (((Boolean)condition.getValue()).booleanValue()) {
            state.getPreprocessingFlags().add(PreprocessingFlag.END_PROCESSING);
            result = AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
            if (context.isVerbose()) {
                context.logForVerbose("Detected " + this.getFullName() + " with active flag");
            }
        }
        return result;
    }
}

