/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.io.IOException;

public class IncludeDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "include";
    }

    @Override
    public String getReference() {
        return "include file content in current preprocess context";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        Value includingFilePath = Expression.evalExpression(string, context);
        String filePath = includingFilePath.toString();
        try {
            File fileToInclude = context.findFileInSources(filePath);
            if (context.isVerbose()) {
                context.logForVerbose("Including file '" + fileToInclude.getCanonicalPath() + '\'');
            }
            state.openFile(fileToInclude);
            PreprocessorUtils.findFirstActiveFileContainer(context).ifPresent(f -> f.getIncludedSources().add(fileToInclude));
        }
        catch (IOException ex) {
            throw context.makeException("Can't open file '" + filePath + '\'', ex);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

