/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class MsgDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "msg";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.TAIL;
    }

    @Override
    public String getReference() {
        return "following text will be logged as info, macroses allowed, if verbose is ON then stack info will be logged";
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String rawTail, PreprocessorContext context) {
        String normal = !rawTail.isEmpty() && Character.isSpaceChar(rawTail.charAt(0)) ? rawTail.substring(1) : rawTail;
        String message = PreprocessorUtils.processMacroses(normal, context);
        if (context.isVerbose()) {
            context.logForVerbose(message);
        } else {
            context.logInfo(message);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

