/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;

public class OutdirDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "outdir";
    }

    @Override
    public String getReference() {
        return "change target file folder (same as change 'jcp.dst.dir')";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        Value name = Expression.evalExpression(string, context);
        String nameAsString = name.toString();
        if (context.isVerbose()) {
            context.logForVerbose("Change result file folder '" + nameAsString + "'");
        }
        context.getPreprocessingState().getRootFileInfo().setTargetFolder(nameAsString);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

