/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.exceptions;

import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.util.Objects;

public class FilePositionInfo {
    private final File file;
    private final int stringIndex;

    public FilePositionInfo(File file, int stringIndex) {
        Objects.requireNonNull(file, "File is null");
        this.file = file;
        this.stringIndex = stringIndex;
    }

    public File getFile() {
        return this.file;
    }

    public int getStringIndex() {
        return this.stringIndex < 0 ? -1 : this.stringIndex;
    }

    public int getLineNumber() {
        return this.stringIndex < 0 ? -1 : this.stringIndex + 1;
    }

    public String toString() {
        String filePath = PreprocessorUtils.getFilePath(this.file);
        return filePath + ':' + this.getLineNumber();
    }
}

