/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.ExpressionTreeElement;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.Variable;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.functions.FunctionDefinedByUser;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;

public final class ExpressionParser {
    private static final ExpressionParser INSTANCE = new ExpressionParser();

    public static ExpressionParser getInstance() {
        return INSTANCE;
    }

    private static boolean isDelimiterOrOperatorChar(char chr) {
        return ExpressionParser.isDelimiter(chr) || ExpressionParser.isOperatorChar(chr);
    }

    private static boolean isDelimiter(char chr) {
        switch (chr) {
            case '(': 
            case ')': 
            case ',': {
                return true;
            }
        }
        return false;
    }

    private static boolean isOperatorChar(char chr) {
        switch (chr) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public ExpressionTree parse(String expressionStr, PreprocessorContext context) throws IOException {
        Objects.requireNonNull(expressionStr, "Expression is null");
        PushbackReader reader = new PushbackReader(new StringReader(expressionStr));
        PreprocessingState state = context.getPreprocessingState();
        ExpressionTree result = new ExpressionTree(state.makeIncludeStack(), state.getLastReadString());
        if (this.readExpression(reader, result, context, false, false) != null) {
            String text = "Unexpected result during parsing [" + expressionStr + ']';
            throw context.makeException(text, null);
        }
        result.postProcess();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ExpressionItem readExpression(PushbackReader reader, ExpressionTree tree, PreprocessorContext context, boolean insideBracket, boolean argument) throws IOException {
        boolean working = true;
        ExpressionItem result = null;
        PreprocessingState state = context.getPreprocessingState();
        FilePositionInfo[] stack = state.makeIncludeStack();
        String sourceLine = state.getLastReadString();
        ExpressionItem prev = null;
        while (true) {
            ExpressionItem nextItem;
            block14: {
                block16: {
                    String text;
                    block15: {
                        if (!working) {
                            return result;
                        }
                        nextItem = this.nextItem(reader, context);
                        if (nextItem != null) break block15;
                        working = false;
                        result = null;
                        break block14;
                    }
                    if (nextItem.getExpressionItemType() != ExpressionItemType.SPECIAL) break block16;
                    if (nextItem == SpecialItem.BRACKET_CLOSING) {
                        if (insideBracket) {
                            working = false;
                            result = nextItem;
                            break block14;
                        } else {
                            if (!argument) {
                                text = "Detected alone closing bracket";
                                throw context.makeException("Detected alone closing bracket", null);
                            }
                            working = false;
                            result = nextItem;
                        }
                        break block14;
                    } else if (nextItem == SpecialItem.BRACKET_OPENING) {
                        if (prev != null && prev.getExpressionItemType() == ExpressionItemType.VARIABLE) {
                            text = "Unknown function detected [" + prev.toString() + ']';
                            throw context.makeException(text, null);
                        }
                        ExpressionTree subExpression = new ExpressionTree(stack, sourceLine);
                        if (SpecialItem.BRACKET_CLOSING != this.readExpression(reader, subExpression, context, true, false)) {
                            String text2 = "Detected unclosed bracket";
                            throw context.makeException("Detected unclosed bracket", null);
                        }
                        tree.addTree(subExpression);
                        break block14;
                    } else if (nextItem == SpecialItem.COMMA) {
                        return nextItem;
                    }
                    break block14;
                }
                if (nextItem.getExpressionItemType() == ExpressionItemType.FUNCTION) {
                    AbstractFunction function = (AbstractFunction)nextItem;
                    ExpressionTree functionTree = this.readFunction(function, reader, context, stack, sourceLine);
                    tree.addTree(functionTree);
                } else {
                    tree.addItem(nextItem);
                }
            }
            prev = nextItem;
        }
    }

    private ExpressionTree readFunction(AbstractFunction function, PushbackReader reader, PreprocessorContext context, FilePositionInfo[] includeStack, String sources) throws IOException {
        ExpressionTree functionTree;
        ExpressionItem expectedBracket = this.nextItem(reader, context);
        if (expectedBracket == null) {
            throw context.makeException("Detected function without params [" + function.getName() + ']', null);
        }
        int arity = function.getArity();
        if (arity == 0) {
            ExpressionTree subExpression = new ExpressionTree(includeStack, sources);
            ExpressionItem lastItem = this.readFunctionArgument(reader, subExpression, context, includeStack, sources);
            if (SpecialItem.BRACKET_CLOSING != lastItem) {
                throw context.makeException("There is not closing bracket for function [" + function.getName() + ']', null);
            }
            if (!subExpression.getRoot().isEmptySlot()) {
                throw context.makeException("The function '" + function.getName() + "' doesn't need arguments", null);
            }
            functionTree = new ExpressionTree(includeStack, sources);
            functionTree.addItem(function);
        } else {
            ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>(arity);
            for (int i = 0; i < function.getArity(); ++i) {
                ExpressionTree subExpression = new ExpressionTree(includeStack, sources);
                ExpressionItem lastItem = this.readFunctionArgument(reader, subExpression, context, includeStack, sources);
                if (SpecialItem.BRACKET_CLOSING == lastItem) {
                    arguments.add(subExpression);
                    break;
                }
                if (SpecialItem.COMMA != lastItem) {
                    throw context.makeException("Wrong argument for function [" + function.getName() + ']', null);
                }
                arguments.add(subExpression);
            }
            functionTree = new ExpressionTree(includeStack, sources);
            functionTree.addItem(function);
            ExpressionTreeElement functionTreeElement = functionTree.getRoot();
            if (arguments.size() != functionTreeElement.getArity()) {
                throw context.makeException("Wrong argument number detected '" + function.getName() + "', must be " + function.getArity() + " argument(s)", null);
            }
            functionTreeElement.fillArguments(arguments);
        }
        return functionTree;
    }

    ExpressionItem readFunctionArgument(PushbackReader reader, ExpressionTree tree, PreprocessorContext context, FilePositionInfo[] callStack, String source) throws IOException {
        boolean working = true;
        ExpressionItem result = null;
        while (working) {
            ExpressionItem nextItem = this.nextItem(reader, context);
            if (nextItem == null) {
                throw context.makeException("Non-closed function detected", null);
            }
            if (SpecialItem.COMMA == nextItem) {
                result = nextItem;
                working = false;
                continue;
            }
            if (SpecialItem.BRACKET_OPENING == nextItem) {
                ExpressionTree subExpression = new ExpressionTree(callStack, source);
                if (SpecialItem.BRACKET_CLOSING != this.readExpression(reader, subExpression, context, true, false)) {
                    throw context.makeException("Non-closed bracket inside a function argument detected", null);
                }
                tree.addTree(subExpression);
                continue;
            }
            if (SpecialItem.BRACKET_CLOSING == nextItem) {
                result = nextItem;
                working = false;
                continue;
            }
            if (nextItem.getExpressionItemType() == ExpressionItemType.FUNCTION) {
                AbstractFunction function = (AbstractFunction)nextItem;
                ExpressionTree functionTree = this.readFunction(function, reader, context, callStack, source);
                tree.addTree(functionTree);
                continue;
            }
            tree.addItem(nextItem);
        }
        return result;
    }

    private int hex2int(PreprocessorContext context, char chr) {
        int result;
        if (Character.isDigit(chr)) {
            result = chr - 48;
        } else {
            result = 10 + (chr - Character.toLowerCase(chr) - 97);
            if (result < 10 || result > 15) {
                throw context.makeException("Unexpected hex digit detected: " + chr, null);
            }
        }
        return result;
    }

    ExpressionItem nextItem(PushbackReader reader, PreprocessorContext context) throws IOException {
        Objects.requireNonNull(reader, "Reader is null");
        ParserState state = ParserState.WAIT;
        StringBuilder builder = new StringBuilder(12);
        boolean found = false;
        char unicodeChar = '\u0000';
        while (!found) {
            int data = reader.read();
            if (data < 0) {
                if (state == ParserState.WAIT) break;
                found = true;
                break;
            }
            char chr = (char)data;
            block0 : switch (state.ordinal()) {
                case 0: {
                    if (Character.isWhitespace(chr)) break;
                    if (chr == ',') {
                        return SpecialItem.COMMA;
                    }
                    if (chr == '(') {
                        return SpecialItem.BRACKET_OPENING;
                    }
                    if (chr == ')') {
                        return SpecialItem.BRACKET_CLOSING;
                    }
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        if (chr == '0') {
                            state = ParserState.HEX_NUMBER;
                            break;
                        }
                        state = ParserState.NUMBER;
                        break;
                    }
                    if (chr == '.') {
                        builder.append('.');
                        state = ParserState.FLOAT_NUMBER;
                        break;
                    }
                    if (Character.isLetter(chr) || chr == '$' || chr == '_') {
                        builder.append(chr);
                        state = ParserState.VALUE_OR_FUNCTION;
                        break;
                    }
                    if (chr == '\"') {
                        state = ParserState.STRING;
                        break;
                    }
                    if (ExpressionParser.isOperatorChar(chr)) {
                        builder.append(chr);
                        state = ParserState.OPERATOR;
                        break;
                    }
                    throw context.makeException("Unsupported token character detected '" + chr + '\'', null);
                }
                case 11: {
                    if (!ExpressionParser.isOperatorChar(chr) || ExpressionParser.isDelimiter(chr)) {
                        reader.unread(data);
                        found = true;
                        break;
                    }
                    builder.append(chr);
                    break;
                }
                case 3: {
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        break;
                    }
                    found = true;
                    reader.unread(data);
                    break;
                }
                case 2: {
                    if (builder.length() == 1) {
                        if (chr == 'X' || chr == 'x') {
                            builder.append(chr);
                            break;
                        }
                        if (chr == '.') {
                            builder.append(chr);
                            state = ParserState.FLOAT_NUMBER;
                            break;
                        }
                        if (Character.isDigit(chr)) {
                            state = ParserState.NUMBER;
                            break;
                        }
                        state = ParserState.NUMBER;
                        found = true;
                        reader.unread(data);
                        break;
                    }
                    if (Character.isDigit(chr) || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F') {
                        builder.append(chr);
                        break;
                    }
                    found = true;
                    reader.unread(data);
                    break;
                }
                case 6: {
                    unicodeChar = (char)(this.hex2int(context, chr) << 12);
                    state = ParserState.UNICODE_DIGIT1;
                    break;
                }
                case 7: {
                    unicodeChar = (char)(unicodeChar | this.hex2int(context, chr) << 8);
                    state = ParserState.UNICODE_DIGIT2;
                    break;
                }
                case 8: {
                    unicodeChar = (char)(unicodeChar | this.hex2int(context, chr) << 4);
                    state = ParserState.UNICODE_DIGIT3;
                    break;
                }
                case 9: {
                    unicodeChar = (char)(unicodeChar | this.hex2int(context, chr));
                    state = ParserState.STRING;
                    builder.append(unicodeChar);
                    break;
                }
                case 1: {
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        break;
                    }
                    if (chr == '.') {
                        builder.append(chr);
                        state = ParserState.FLOAT_NUMBER;
                        break;
                    }
                    reader.unread(data);
                    found = true;
                    break;
                }
                case 10: {
                    if (Character.isWhitespace(chr) || ExpressionParser.isDelimiterOrOperatorChar(chr)) {
                        reader.unread(data);
                        found = true;
                        break;
                    }
                    builder.append(chr);
                    break;
                }
                case 5: {
                    switch (chr) {
                        case 'n': {
                            builder.append('\n');
                            break;
                        }
                        case 't': {
                            builder.append('\t');
                            break;
                        }
                        case 'b': {
                            builder.append('\b');
                            break;
                        }
                        case 'f': {
                            builder.append('\f');
                            break;
                        }
                        case 'r': {
                            builder.append('\r');
                            break;
                        }
                        case '\\': {
                            builder.append('\\');
                            break;
                        }
                        case '\"': {
                            builder.append('\"');
                            break;
                        }
                        case '\'': {
                            builder.append('\'');
                            break;
                        }
                        case 'u': {
                            state = ParserState.UNICODE_DIGIT0;
                            break;
                        }
                        default: {
                            throw context.makeException("Unsupported special char detected '\\" + chr + '\'', null);
                        }
                    }
                    state = state == ParserState.SPECIAL_CHAR ? ParserState.STRING : state;
                    break;
                }
                case 4: {
                    switch (chr) {
                        case '\"': {
                            found = true;
                            break block0;
                        }
                        case '\\': {
                            state = ParserState.SPECIAL_CHAR;
                            break block0;
                        }
                    }
                    builder.append(chr);
                    break;
                }
                default: {
                    throw new Error("Unsupported parser state [" + state.name() + ']');
                }
            }
        }
        if (!found) {
            switch (state.ordinal()) {
                case 6: 
                case 7: 
                case 8: {
                    throw context.makeException("Non-completed unicode char has been detected", null);
                }
                case 4: 
                case 5: {
                    throw context.makeException("Non-closed string has been detected", null);
                }
            }
            return null;
        }
        ExpressionItem result = null;
        switch (state.ordinal()) {
            case 3: {
                result = Value.valueOf(Float.valueOf(Float.parseFloat(builder.toString())));
                break;
            }
            case 2: {
                String text = builder.toString();
                if ("0".equals(text)) {
                    result = Value.INT_ZERO;
                    break;
                }
                String str = PreprocessorUtils.extractTail("0x", text);
                result = Value.valueOf(Long.parseLong(str, 16));
                break;
            }
            case 1: {
                result = Value.valueOf(Long.parseLong(builder.toString()));
                break;
            }
            case 11: {
                String operatorLC = builder.toString().toLowerCase(Locale.ENGLISH);
                for (AbstractOperator operator : AbstractOperator.getAllOperators()) {
                    if (!operator.getKeyword().equals(operatorLC)) continue;
                    result = operator;
                    break;
                }
                if (result != null) break;
                throw context.makeException("Unknown operator detected '" + operatorLC + '\'', null);
            }
            case 4: {
                result = Value.valueOf(builder.toString());
                break;
            }
            case 10: {
                String str = builder.toString().toLowerCase();
                if (str.charAt(0) == '$') {
                    Objects.requireNonNull(context, "There is not a preprocessor context to define a user function [" + str + ']');
                    PreprocessorExtension extension = context.getPreprocessorExtension();
                    if (extension == null) {
                        throw context.makeException("There is not any defined preprocessor extension to get data about user functions [" + str + ']', null);
                    }
                    String userFunctionName = PreprocessorUtils.extractTail("$", str);
                    result = new FunctionDefinedByUser(userFunctionName, extension.getUserFunctionArity(userFunctionName), context);
                    break;
                }
                if ("true".equals(str)) {
                    result = Value.BOOLEAN_TRUE;
                    break;
                }
                if ("false".equals(str)) {
                    result = Value.BOOLEAN_FALSE;
                    break;
                }
                AbstractFunction function = AbstractFunction.findForName(str);
                if (function == null) {
                    result = new Variable(str);
                    break;
                }
                result = function;
                break;
            }
            default: {
                throw new Error("Unsupported final parser state detected [" + state.name() + ']');
            }
        }
        return result;
    }

    public static enum SpecialItem implements ExpressionItem
    {
        BRACKET_OPENING,
        BRACKET_CLOSING,
        COMMA;


        @Override
        public ExpressionItemPriority getExpressionItemPriority() {
            return null;
        }

        @Override
        public ExpressionItemType getExpressionItemType() {
            return ExpressionItemType.SPECIAL;
        }
    }

    private static enum ParserState {
        WAIT,
        NUMBER,
        HEX_NUMBER,
        FLOAT_NUMBER,
        STRING,
        SPECIAL_CHAR,
        UNICODE_DIGIT0,
        UNICODE_DIGIT1,
        UNICODE_DIGIT2,
        UNICODE_DIGIT3,
        VALUE_OR_FUNCTION,
        OPERATOR;

    }
}

