/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import java.util.Locale;

public final class FunctionESC
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    public String getName() {
        return "esc";
    }

    public Value executeStr(PreprocessorContext context, Value source) {
        String sourceString = source.asString();
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < sourceString.length(); ++i) {
            char chr = sourceString.charAt(i);
            switch (chr) {
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                default: {
                    if (chr > '\u007f' || Character.isISOControl(chr)) {
                        String hexCode = Integer.toHexString(chr).toUpperCase(Locale.ENGLISH);
                        if (hexCode.length() < 4) {
                            hexCode = "0000".substring(0, 4 - hexCode.length()) + hexCode;
                        }
                        result.append("\\u").append(hexCode);
                        continue block10;
                    }
                    result.append(chr);
                }
            }
        }
        return Value.valueOf(result.toString());
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public String getReference() {
        return "escape string chars";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

