/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.CommentRemoverType;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.utils.IOUtils;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class FunctionEVALFILE
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    public String getName() {
        return "evalfile";
    }

    @Override
    public String getReference() {
        return "preprocess file and get result as string";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }

    private PreprocessorContext prepareContext(PreprocessorContext base) {
        PreprocessorContext result = new PreprocessorContext(base);
        result.setDryRun(true);
        result.setKeepLines(false);
        result.setClearTarget(false);
        result.setKeepComments(CommentRemoverType.REMOVE_C_STYLE);
        result.setCareForLastEol(true);
        return result;
    }

    public Value executeStr(PreprocessorContext context, Value strFilePath) {
        File fileToEvaluate;
        String filePath = strFilePath.asString();
        try {
            fileToEvaluate = context.findFileInSources(filePath);
        }
        catch (IOException ex) {
            throw context.makeException("Can't get get source file '" + filePath + '\'', null);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Eval file '" + fileToEvaluate + '\'');
        }
        try {
            FileInfoContainer fileContainer = new FileInfoContainer(fileToEvaluate, fileToEvaluate.getName(), false);
            PreprocessorContext evalContext = this.prepareContext(context);
            PreprocessingState state = fileContainer.preprocessFile(null, evalContext);
            PreprocessorUtils.findFirstActiveFileContainer(context).ifPresent(f -> {
                f.getIncludedSources().add(fileToEvaluate);
                f.getIncludedSources().addAll(evalContext.findAllInputFiles());
                f.getGeneratedResources().addAll(evalContext.findAllProducedFiles());
            });
            StringWriter strWriter = new StringWriter(1024);
            state.writePrinterBuffers(strWriter);
            IOUtils.closeQuietly(strWriter);
            return Value.valueOf(strWriter.toString());
        }
        catch (Exception ex) {
            throw context.makeException("Unexpected exception", ex);
        }
    }
}

