/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import hidden.jcp.org.apache.commons.text.StringEscapeUtils;
import java.util.List;

public final class FunctionSTR2JAVA
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.BOOLEAN}};

    @Override
    public String getName() {
        return "str2java";
    }

    public Value executeStrBool(PreprocessorContext context, Value source, Value splitAndQuoteLines) {
        if (splitAndQuoteLines.asBoolean().booleanValue()) {
            boolean endsWithNextLine = source.asString().endsWith("\n");
            List<String> split = PreprocessorUtils.splitForCharAndHoldEmptyLine(source.asString(), '\n');
            StringBuilder result = new StringBuilder(source.asString().length() * 2);
            String nextLineChars = PreprocessorUtils.getNextLineCodes();
            int index = 0;
            for (String s : split) {
                boolean last;
                boolean bl = last = ++index == split.size();
                if (result.length() > 0) {
                    result.append(nextLineChars).append('+');
                }
                result.append('\"').append(StringEscapeUtils.escapeJava(s));
                if (last) {
                    result.append(endsWithNextLine ? "\\n\"" : "\"");
                    continue;
                }
                result.append("\\n\"");
            }
            return Value.valueOf(result.toString());
        }
        return Value.valueOf(StringEscapeUtils.escapeJava(source.asString()));
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public String getReference() {
        return "escape string for Java";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

