/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.extension;

import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogPreprocessorExtension
implements PreprocessorExtension {
    private static final Pattern PATTERN = Pattern.compile("^(\\D+)(\\d+)?$");

    private static String findPosition(PreprocessorContext context) {
        if (context == null) {
            return "";
        }
        if (context.getPreprocessingState().getCurrentIncludeStack().isEmpty()) {
            return "";
        }
        TextFileDataContainer dataContainer = context.getPreprocessingState().getCurrentIncludeStack().get(0);
        return (dataContainer.getFile() == null ? "<unknown>" : dataContainer.getFile().getName()) + ':' + (dataContainer.getLastReadStringIndex() + 1);
    }

    @Override
    public boolean processAction(PreprocessorContext context, Value[] parameters) {
        context.logInfo(String.format("Called action: %s at %s", Arrays.toString(parameters), LogPreprocessorExtension.findPosition(context)));
        return true;
    }

    @Override
    public Value processUserFunction(PreprocessorContext context, String functionName, Value[] arguments) {
        context.logInfo(String.format("Called user function '%s'(%s) at %s", functionName, Arrays.toString(arguments), LogPreprocessorExtension.findPosition(context)));
        return Value.BOOLEAN_TRUE;
    }

    @Override
    public int getUserFunctionArity(String functionName) {
        Matcher matcher = PATTERN.matcher(functionName);
        if (matcher.find() && matcher.group(2) != null) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }
}

