/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.logger;

import com.igormaznitsa.jcp.logger.PreprocessorLogger;

public final class SystemOutLogger
implements PreprocessorLogger {
    public static final String PROPERTY_DEBUG_FLAG = "jcp.log.debug";
    private static final boolean FLAG_DEBUG_LEVEL = Boolean.parseBoolean(System.getProperty("jcp.log.debug"));

    public int hashCode() {
        return System.out.hashCode();
    }

    public boolean equals(Object value) {
        return value instanceof SystemOutLogger;
    }

    @Override
    public void error(String text) {
        if (text != null) {
            String out = "[JCP.ERR] " + text;
            System.err.println(out);
        }
    }

    @Override
    public void info(String text) {
        if (text != null) {
            String out = "[JCP.INFO] " + text;
            System.out.println(out);
        }
    }

    @Override
    public void warning(String text) {
        if (text != null) {
            String out = "[JCP.WARN] " + text;
            System.out.println(out);
        }
    }

    @Override
    public void debug(String text) {
        if (FLAG_DEBUG_LEVEL && text != null) {
            String out = "[JCP.DEBUG] " + text;
            System.out.println(out);
        }
    }
}

