/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.removers;

import com.igormaznitsa.jcp.context.CommentRemoverType;
import com.igormaznitsa.jcp.removers.CStyleCommentRemover;
import com.igormaznitsa.jcp.removers.JcpCommentLineRemover;
import com.igormaznitsa.jcp.removers.JustCopyRemover;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;

public abstract class AbstractCommentRemover {
    protected final Reader srcReader;
    protected final Writer dstWriter;
    protected final boolean whiteSpaceAllowed;

    protected AbstractCommentRemover(Reader src, Writer dst, boolean whiteSpaceAllowed) {
        Objects.requireNonNull(src, "The reader is null");
        Objects.requireNonNull(dst, "The writer is null");
        this.srcReader = src;
        this.dstWriter = dst;
        this.whiteSpaceAllowed = whiteSpaceAllowed;
    }

    public abstract Writer process() throws IOException;

    public static AbstractCommentRemover makeCommentRemover(CommentRemoverType keepComments, Reader src, Writer dst, boolean whiteSpaceAllowed) {
        switch (keepComments) {
            case KEEP_ALL: {
                return new JustCopyRemover(src, dst, whiteSpaceAllowed);
            }
            case REMOVE_C_STYLE: {
                return new CStyleCommentRemover(src, dst, whiteSpaceAllowed);
            }
            case REMOVE_JCP_ONLY: {
                return new JcpCommentLineRemover(src, dst, whiteSpaceAllowed);
            }
        }
        throw new IllegalStateException("Unsupported keep comments value: " + (Object)((Object)keepComments));
    }

    protected void skipTillNextString() throws IOException {
        while (!Thread.currentThread().isInterrupted()) {
            int chr = this.srcReader.read();
            if (chr < 0) {
                return;
            }
            if (chr != 10) continue;
            this.dstWriter.write(chr);
            return;
        }
    }

    protected void skipTillClosingJavaComments() throws IOException {
        boolean starFound = false;
        while (!Thread.currentThread().isInterrupted()) {
            int chr = this.srcReader.read();
            if (chr < 0) {
                return;
            }
            if (starFound) {
                if (chr == 47) {
                    return;
                }
                starFound = chr == 42;
                continue;
            }
            if (chr != 42) continue;
            starFound = true;
        }
    }

    protected void copyTillClosingJavaComments() throws IOException {
        boolean starFound = false;
        while (!Thread.currentThread().isInterrupted()) {
            int chr = this.srcReader.read();
            if (chr < 0) {
                return;
            }
            this.dstWriter.write(chr);
            if (starFound) {
                if (chr == 47) {
                    return;
                }
                starFound = chr == 42;
                continue;
            }
            if (chr != 42) continue;
            starFound = true;
        }
    }

    protected void copyTillNextString() throws IOException {
        while (!Thread.currentThread().isInterrupted()) {
            int chr = this.srcReader.read();
            if (chr < 0) {
                return;
            }
            this.dstWriter.write(chr);
            if (chr != 10) continue;
            break;
        }
    }
}

