/*
 * Decompiled with CFR 0.152.
 */
package hidden.jcp.org.apache.xml.serialize;

import hidden.jcp.org.apache.xerces.dom.DOMMessageFormatter;
import hidden.jcp.org.apache.xml.serialize.HTMLSerializer;
import hidden.jcp.org.apache.xml.serialize.OutputFormat;
import hidden.jcp.org.apache.xml.serialize.Serializer;
import hidden.jcp.org.apache.xml.serialize.SerializerFactory;
import hidden.jcp.org.apache.xml.serialize.TextSerializer;
import hidden.jcp.org.apache.xml.serialize.XHTMLSerializer;
import hidden.jcp.org.apache.xml.serialize.XMLSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string) {
        this._method = string;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string});
            throw new IllegalArgumentException(string2);
        }
    }

    @Override
    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputByteStream(outputStream);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String string = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(string);
    }

    @Override
    protected String getSupportedMethod() {
        return this._method;
    }
}

