/*
 * Decompiled with CFR 0.152.
 */
package hidden.jcp.org.apache.xpath.functions;

import hidden.jcp.javax.xml.transform.TransformerException;
import hidden.jcp.org.apache.xml.dtm.DTMIterator;
import hidden.jcp.org.apache.xml.utils.WrappedRuntimeException;
import hidden.jcp.org.apache.xpath.XPathContext;
import hidden.jcp.org.apache.xpath.axes.SubContextList;
import hidden.jcp.org.apache.xpath.compiler.Compiler;
import hidden.jcp.org.apache.xpath.functions.Function;
import hidden.jcp.org.apache.xpath.objects.XNumber;
import hidden.jcp.org.apache.xpath.objects.XObject;
import java.util.Vector;

public class FuncPosition
extends Function {
    static final long serialVersionUID = -9092846348197271582L;
    private boolean m_isTopLevel;

    @Override
    public void postCompileStep(Compiler compiler) {
        this.m_isTopLevel = compiler.getLocationPathDepth() == -1;
    }

    public int getPositionInContextNodeList(XPathContext xctxt) {
        SubContextList iter;
        SubContextList subContextList = iter = this.m_isTopLevel ? null : xctxt.getSubContextList();
        if (null != iter) {
            int prox = iter.getProximityPosition(xctxt);
            return prox;
        }
        DTMIterator cnl = xctxt.getContextNodeList();
        if (null != cnl) {
            int n = cnl.getCurrentNode();
            if (n == -1) {
                if (cnl.getCurrentPos() == 0) {
                    return 0;
                }
                try {
                    cnl = cnl.cloneWithReset();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new WrappedRuntimeException(cnse);
                }
                int currentNode = xctxt.getContextNode();
                while (-1 != (n = cnl.nextNode()) && n != currentNode) {
                }
            }
            return cnl.getCurrentPos();
        }
        return -1;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        double pos = this.getPositionInContextNodeList(xctxt);
        return new XNumber(pos);
    }

    @Override
    public void fixupVariables(Vector vars, int globalsSize) {
    }
}

