/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker;

import com.igormaznitsa.meta.Complexity;
import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.MetaAnnotations;
import com.igormaznitsa.meta.checker.Utils;
import com.igormaznitsa.meta.checker.extracheck.MethodParameterChecker;
import com.igormaznitsa.meta.checker.jversion.JavaVersion;
import com.igormaznitsa.meta.checker.jversion.LongComparator;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.meta.common.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckerMojo
extends AbstractMojo {
    private static final String DELIMITER = "................................";
    private static final String FAILURE_STRING = "Detected annotation '%s' defined to be recognized as error";
    private static final String[] BANNER = new String[]{"  __  __  ____  ____   __   ", " (  \\/  )( ___)(_  _) /__\\  ", "  )    (  )__)   )(  /(__)\\ ", " (_/\\/\\_)(____) (__)(__)(__)", "https://github.com/raydac/meta", ""};
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.outputDirectory}", name="targetDirectory")
    private String targetDirectory;
    @Parameter(name="restrictClassFormat")
    private String restrictClassFormat;
    @Parameter(name="failForAnnotations")
    private String[] failForAnnotations;
    @Parameter(name="ignoreClasses")
    private String[] ignoreClasses;
    @Parameter(name="checkNullable", defaultValue="false")
    private boolean checkNullable;
    @Parameter(name="checkMayContainNull", defaultValue="false")
    private boolean checkMayContainNull;
    @Parameter(name="maxAllowedWeight")
    private String maxAllowedWeight;
    @Parameter(name="maxAllowedTimeComplexity")
    private String maxAllowedTimeComplexity;
    @Parameter(name="maxAllowedMemoryComplexity")
    private String maxAllowedMemoryComplexity;
    @Parameter(name="hideBanner", defaultValue="false")
    private boolean hideBanner;
    private LongComparator comparatorForJavaVersion;
    private JavaVersion decodedJavaVersion;
    private Pattern[] ignoreClassesAsPatterns;

    public String getMaxAllowedWeight() {
        return this.maxAllowedWeight;
    }

    public String getMaxAllowedTimeComplexity() {
        return this.maxAllowedTimeComplexity;
    }

    public String getMaxAllowedMemoryComplexity() {
        return this.maxAllowedMemoryComplexity;
    }

    private static Weight.Unit decodeWeight(String value) {
        String normalized = StrUtils.pressing((String)GetUtils.ensureNonNullStr((String)value)).replace("_", "");
        if (normalized.isEmpty()) {
            return null;
        }
        for (Weight.Unit u : Weight.Unit.values()) {
            if (!normalized.equalsIgnoreCase(StrUtils.pressing((String)u.name()).replace("_", ""))) continue;
            return u;
        }
        throw new NoSuchElementException("Can't recognize weight unit for its name : " + value);
    }

    private static Complexity decodeComplexity(String value) {
        String normalized = StrUtils.pressing((String)GetUtils.ensureNonNullStr((String)value)).replace("_", "");
        if (normalized.isEmpty()) {
            return null;
        }
        Complexity detected = null;
        for (Complexity c : Complexity.values()) {
            String name = StrUtils.pressing((String)c.name()).replace("_", "");
            String formula = StrUtils.pressing((String)c.getFormula()).replace("_", "");
            if (!normalized.equalsIgnoreCase(name) && !normalized.equalsIgnoreCase(formula)) continue;
            detected = c;
            break;
        }
        if (detected == null) {
            throw new NoSuchElementException("Can't recognize complexity level from string value : " + value);
        }
        return detected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        int processedClasses;
        long startTime;
        AtomicInteger counterErrors;
        AtomicInteger counterWarings;
        HashMap<String, AtomicInteger> counters;
        block41: {
            Complexity theMaxAllowedMemoryComplexity;
            Complexity theMaxAllowedTimeComplexity;
            Weight.Unit theMaxAllowedWeight;
            this.prepareIgnoreClassPatterns();
            final File targetDirectoryFile = new File(this.targetDirectory);
            if (!targetDirectoryFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Can't find directory for investigation, may be there are not classes for compilation : " + this.targetDirectory));
                return;
            }
            if (!this.hideBanner && !this.session.isParallel()) {
                for (String s : BANNER) {
                    this.getLog().info((CharSequence)s);
                }
                this.getLog().info((CharSequence)DELIMITER);
            }
            this.getLog().info((CharSequence)("Folder to look for classes : " + targetDirectoryFile.getAbsolutePath()));
            this.getLog().info((CharSequence)DELIMITER);
            if (this.restrictClassFormat != null) {
                int versionOffset;
                String javaClassVersion = this.restrictClassFormat.trim();
                if (javaClassVersion.isEmpty()) {
                    throw new IllegalArgumentException("Detected empty value for 'restrictClassFormat'");
                }
                this.comparatorForJavaVersion = LongComparator.find(javaClassVersion);
                if (this.comparatorForJavaVersion == null) {
                    if (Character.isDigit(javaClassVersion.charAt(0))) {
                        this.comparatorForJavaVersion = LongComparator.EQU;
                    }
                    versionOffset = 0;
                } else {
                    versionOffset = this.comparatorForJavaVersion.getText().length();
                }
                javaClassVersion = javaClassVersion.substring(versionOffset).trim();
                this.decodedJavaVersion = JavaVersion.decode(javaClassVersion);
                if (this.decodedJavaVersion == null) {
                    throw new IllegalArgumentException("Illegal java version in 'restrictClassFormat': " + javaClassVersion);
                }
            }
            counters = new HashMap<String, AtomicInteger>();
            counterWarings = new AtomicInteger();
            counterErrors = new AtomicInteger();
            final AtomicInteger counterInfo = new AtomicInteger();
            try {
                theMaxAllowedWeight = CheckerMojo.decodeWeight(this.getMaxAllowedWeight());
            }
            catch (NoSuchElementException ex) {
                this.getLog().error((CharSequence)("Can't recognize weight value : " + this.getMaxAllowedWeight()));
                this.getLog().error((CharSequence)("Allowed values : " + Arrays.toString(Weight.Unit.values())));
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            try {
                theMaxAllowedTimeComplexity = CheckerMojo.decodeComplexity(this.getMaxAllowedTimeComplexity());
                theMaxAllowedMemoryComplexity = CheckerMojo.decodeComplexity(this.getMaxAllowedMemoryComplexity());
            }
            catch (NoSuchElementException ex) {
                this.getLog().error((CharSequence)"Can't recognize a complexity constant");
                this.getLog().error((CharSequence)("Allowed values : " + Arrays.toString(Complexity.values())));
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            Context context = new Context(){
                FieldOrMethod node;
                JavaClass klazz;
                int itemIndex;

                @Override
                public Weight.Unit getMaxAllowedWeightLevel() {
                    return theMaxAllowedWeight;
                }

                @Override
                public Complexity getMaxAllowedTimeComplexity() {
                    return theMaxAllowedTimeComplexity;
                }

                @Override
                public Complexity getMaxAllowedMemoryComplexity() {
                    return theMaxAllowedMemoryComplexity;
                }

                @Override
                public JavaClass getProcessingClass() {
                    return this.klazz;
                }

                @Override
                public int getItemIndex() {
                    return this.itemIndex;
                }

                @Override
                public boolean isCheckNullableArgs() {
                    return CheckerMojo.this.checkNullable;
                }

                @Override
                public boolean isCheckMayContainNullArgs() {
                    return CheckerMojo.this.checkMayContainNull;
                }

                @Override
                public File getTargetDirectoryFolder() {
                    return targetDirectoryFile;
                }

                public String currentProcessingItemAsString() {
                    StringBuilder builder = new StringBuilder();
                    int line = Utils.findLineNumber(this.node);
                    String klazzName = Utils.normalizeClassNameAndRemoveSubclassName(((JavaClass)Assertions.assertNotNull((Object)this.klazz)).getClassName());
                    String nodeName = Utils.asString(this.klazz, this.node);
                    builder.append(klazzName).append(".java").append(":[");
                    if (line < 0) {
                        builder.append("-,-]");
                    } else {
                        builder.append(line).append(',').append(1).append(']');
                    }
                    builder.append(' ');
                    if (this.node != null) {
                        if (this.node instanceof Field) {
                            builder.append("field ").append(nodeName);
                        } else {
                            Method method = (Method)this.node;
                            if (method.getName().equals("<init>")) {
                                builder.append("constructor ");
                            } else {
                                builder.append("method ");
                            }
                            builder.append(nodeName).append(" (flags: #").append(Integer.toHexString(method.getAccessFlags()).toUpperCase(Locale.ENGLISH)).append(") ");
                        }
                    } else {
                        builder.append("whole class");
                    }
                    return builder.toString();
                }

                @Override
                public void setProcessingItem(JavaClass klazz, FieldOrMethod node, int itemIndex) {
                    this.node = node;
                    this.klazz = klazz;
                    this.itemIndex = itemIndex;
                }

                @Override
                public FieldOrMethod getNode() {
                    return this.node;
                }

                @Override
                public void info(String info, boolean showProcessingItem) {
                    counterInfo.incrementAndGet();
                    CheckerMojo.this.getLog().info((CharSequence)((showProcessingItem ? this.currentProcessingItemAsString() + ' ' : "") + info));
                }

                @Override
                public void warning(String warning, boolean showProcessingItem) {
                    counterWarings.incrementAndGet();
                    CheckerMojo.this.getLog().warn((CharSequence)((showProcessingItem ? this.currentProcessingItemAsString() + ' ' : "") + warning));
                }

                @Override
                public void error(String error, boolean showProcessingItem) {
                    counterErrors.incrementAndGet();
                    CheckerMojo.this.getLog().error((CharSequence)((showProcessingItem ? this.currentProcessingItemAsString() + ' ' : "") + error));
                }

                @Override
                public void abort(String error, boolean showProcessingItem) {
                    throw new AbortException((showProcessingItem ? this.currentProcessingItemAsString() + ' ' : "") + error);
                }

                @Override
                public void countDetectedAnnotation(String annotationClassName) {
                    AtomicInteger counter = (AtomicInteger)counters.get(annotationClassName);
                    if (counter == null) {
                        counter = new AtomicInteger();
                        counters.put(annotationClassName, counter);
                    }
                    counter.incrementAndGet();
                }
            };
            startTime = System.currentTimeMillis();
            processedClasses = 0;
            try {
                Iterator iterator = FileUtils.iterateFiles((File)targetDirectoryFile, (String[])new String[]{"class", "CLASS"}, (boolean)true);
                int classIndex = 0;
                while (iterator.hasNext() && !Thread.currentThread().isInterrupted()) {
                    File file = (File)iterator.next();
                    this.getLog().debug((CharSequence)String.format("Processing class file : %s", file.getAbsolutePath()));
                    try {
                        JavaClass javaClass = new ClassParser(file.getAbsolutePath()).parse();
                        if (this.isClassIgnored(javaClass)) {
                            context.info(String.format("Ignored class file : %s", file.getAbsolutePath()), false);
                            continue;
                        }
                        ++processedClasses;
                        if (!this.isClassVersionAllowed(javaClass)) {
                            context.error(String.format("Detected class version violator, version %s at %s", new Object[]{JavaVersion.decode(javaClass.getMajor()), file.getAbsolutePath()}), false);
                            counterErrors.incrementAndGet();
                            break;
                        }
                        CheckerMojo.countAllDetectedAnnotations(context, javaClass);
                        ++classIndex;
                        for (MetaAnnotations p : MetaAnnotations.values()) {
                            p.getInstance().processClass(context, javaClass, classIndex);
                        }
                        this.checkMethodsForMarkedObjectTypes(context, javaClass);
                    }
                    catch (AbortException abortException) {
                        throw new MojoFailureException(abortException.getMessage());
                    }
                    catch (IOException iOException) {
                        context.error(String.format("Can't read class file : %s", file.getAbsolutePath()), false);
                    }
                    catch (ClassFormatException classFormatException) {
                        context.error(String.format("Can't parse class file : %s", file.getAbsolutePath()), false);
                    }
                }
                if (this.failForAnnotations != null && this.failForAnnotations.length > 0) {
                    this.getLog().debug((CharSequence)("Defined annotations to be interpreted as error : " + Arrays.toString(this.failForAnnotations)));
                    for (Map.Entry entry : counters.entrySet()) {
                        if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                        String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
                        String shortName = Utils.extractShortNameOfClass(name);
                        for (String s : this.failForAnnotations) {
                            String text;
                            if (s.indexOf(46) < 0) {
                                if (!shortName.equalsIgnoreCase(s)) continue;
                                text = String.format(FAILURE_STRING, s);
                                context.error(text, false);
                                continue;
                            }
                            if (!name.equalsIgnoreCase(s)) continue;
                            text = String.format(FAILURE_STRING, s);
                            context.error(text, false);
                        }
                    }
                    if (counterErrors.get() > 0) {
                        throw new MojoFailureException(String.format("Detected %d error(s)", counterErrors.get()));
                    }
                } else {
                    this.getLog().debug((CharSequence)"There are not defined annotations to be interpreted as error");
                }
                if ((counterErrors.get() | counterInfo.get() | counterWarings.get()) == 0) break block41;
            }
            catch (Throwable throwable) {
                if ((counterErrors.get() | counterInfo.get() | counterWarings.get()) != 0) {
                    this.getLog().info((CharSequence)DELIMITER);
                }
                int totalAnnotations = 0;
                for (Map.Entry e : counters.entrySet()) {
                    totalAnnotations += ((AtomicInteger)e.getValue()).get();
                }
                this.getLog().info((CharSequence)String.format("Processed classes : %d", processedClasses));
                this.getLog().info((CharSequence)String.format("Detected annotations : %d", totalAnnotations));
                this.getLog().info((CharSequence)String.format("Detected To-Do : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.TODO)));
                this.getLog().info((CharSequence)String.format("Detected risks : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.RISKY)));
                this.getLog().info((CharSequence)String.format("Detected experimental : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.EXPERIMENTAL)));
                if (counterWarings.get() > 0) {
                    this.getLog().warn((CharSequence)String.format("Total warnings : %d", counterWarings.get()));
                } else {
                    this.getLog().info((CharSequence)String.format("Total warnings : %d", counterWarings.get()));
                }
                if (counterErrors.get() > 0) {
                    this.getLog().error((CharSequence)String.format("Total errors : %d", counterErrors.get()));
                } else {
                    this.getLog().info((CharSequence)String.format("Total errors : %d", counterErrors.get()));
                }
                this.getLog().info((CharSequence)DELIMITER);
                this.getLog().info((CharSequence)String.format("Total spent time : %s", Utils.printTimeDelay(System.currentTimeMillis() - startTime)));
                throw throwable;
            }
            this.getLog().info((CharSequence)DELIMITER);
        }
        int totalAnnotations = 0;
        for (Map.Entry e : counters.entrySet()) {
            totalAnnotations += ((AtomicInteger)e.getValue()).get();
        }
        this.getLog().info((CharSequence)String.format("Processed classes : %d", processedClasses));
        this.getLog().info((CharSequence)String.format("Detected annotations : %d", totalAnnotations));
        this.getLog().info((CharSequence)String.format("Detected To-Do : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.TODO)));
        this.getLog().info((CharSequence)String.format("Detected risks : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.RISKY)));
        this.getLog().info((CharSequence)String.format("Detected experimental : %d", CheckerMojo.extractCounter(counters, MetaAnnotations.EXPERIMENTAL)));
        if (counterWarings.get() > 0) {
            this.getLog().warn((CharSequence)String.format("Total warnings : %d", counterWarings.get()));
        } else {
            this.getLog().info((CharSequence)String.format("Total warnings : %d", counterWarings.get()));
        }
        if (counterErrors.get() > 0) {
            this.getLog().error((CharSequence)String.format("Total errors : %d", counterErrors.get()));
        } else {
            this.getLog().info((CharSequence)String.format("Total errors : %d", counterErrors.get()));
        }
        this.getLog().info((CharSequence)DELIMITER);
        this.getLog().info((CharSequence)String.format("Total spent time : %s", Utils.printTimeDelay(System.currentTimeMillis() - startTime)));
        if (counterErrors.get() > 0) {
            throw new MojoFailureException(String.format("Detected %d error(s), see the log", counterErrors.get()));
        }
    }

    public boolean isHideBanner() {
        return this.hideBanner;
    }

    public String getRestrictClassFormat() {
        return this.restrictClassFormat;
    }

    public boolean isCheckMayContainNullArgs() {
        return this.checkMayContainNull;
    }

    public boolean isCheckNullableArgs() {
        return this.checkNullable;
    }

    public String[] getIgnoreClasses() {
        return this.ignoreClasses;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public String[] getFailForAnnotations() {
        return this.failForAnnotations;
    }

    private void prepareIgnoreClassPatterns() {
        this.ignoreClassesAsPatterns = null;
        if (this.ignoreClasses != null) {
            this.ignoreClassesAsPatterns = new Pattern[this.ignoreClasses.length];
            int index = 0;
            for (String str : this.ignoreClasses) {
                this.ignoreClassesAsPatterns[index++] = Pattern.compile(Utils.escapeRegexToWildCat(str));
            }
        }
    }

    private void checkMethodsForMarkedObjectTypes(Context context, JavaClass clazz) {
        if ((context.isCheckMayContainNullArgs() || context.isCheckNullableArgs()) && !clazz.isAnnotation() && !clazz.isSynthetic()) {
            int index = 0;
            for (Method m : clazz.getMethods()) {
                boolean skipCheckParameters;
                context.setProcessingItem(clazz, (FieldOrMethod)m, index++);
                String name = m.getName();
                if ("<clinit>".equals(name) || (m.getModifiers() & 0x1040) != 0) continue;
                boolean bl = skipCheckParameters = clazz.isNested() && m.getAccessFlags() == 0 && "<init>".equals(m.getName());
                if (clazz.isEnum() && ("values".equals(name) || "valueOf".equals(name) || "<init>".equals(name))) continue;
                if (context.isCheckNullableArgs()) {
                    MethodParameterChecker.checkReturnTypeForNullable(context, m);
                    if (!skipCheckParameters) {
                        MethodParameterChecker.checkParamsTypeForNullable(context, m);
                    }
                }
                if (!context.isCheckMayContainNullArgs()) continue;
                MethodParameterChecker.checkReturnTypeForMayContainNull(context, m);
                if (skipCheckParameters) continue;
                MethodParameterChecker.checkParamsTypeForMayContainNull(context, m);
            }
        }
    }

    private boolean isClassIgnored(JavaClass clazz) {
        if (this.ignoreClassesAsPatterns == null || this.ignoreClassesAsPatterns.length == 0) {
            return false;
        }
        String klazzName = clazz.getClassName();
        for (Pattern pattern : this.ignoreClassesAsPatterns) {
            if (!pattern.matcher(klazzName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isClassVersionAllowed(JavaClass klazz) {
        if (this.comparatorForJavaVersion == null) {
            return true;
        }
        return this.comparatorForJavaVersion.compare(klazz.getMajor(), ((JavaVersion)((Object)Assertions.assertNotNull((Object)((Object)this.decodedJavaVersion)))).getValue());
    }

    private static void countAllDetectedAnnotations(Context context, JavaClass clazz) {
        for (AnnotationEntry annotationEntry : clazz.getAnnotationEntries()) {
            context.countDetectedAnnotation(Utils.classNameToNormalView(annotationEntry.getAnnotationType()));
        }
        for (AnnotationEntry annotationEntry : clazz.getFields()) {
            for (AnnotationEntry annotationEntry2 : annotationEntry.getAnnotationEntries()) {
                context.countDetectedAnnotation(Utils.classNameToNormalView(annotationEntry2.getAnnotationType()));
            }
        }
        for (AnnotationEntry annotationEntry : clazz.getMethods()) {
            for (AnnotationEntry annotationEntry3 : annotationEntry.getAnnotationEntries()) {
                context.countDetectedAnnotation(Utils.classNameToNormalView(annotationEntry3.getAnnotationType()));
            }
            for (AnnotationEntry annotationEntry4 : annotationEntry.getParameterAnnotationEntries()) {
                for (AnnotationEntry ae : annotationEntry4.getAnnotationEntries()) {
                    context.countDetectedAnnotation(Utils.classNameToNormalView(ae.getAnnotationType()));
                }
            }
        }
    }

    private static int extractCounter(Map<String, AtomicInteger> counters, MetaAnnotations annotation) {
        AtomicInteger result = counters.get(annotation.getAnnotationClassName());
        return result == null ? 0 : result.get();
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = -1153122159632822978L;

        public AbortException(String message) {
            super(message);
        }
    }
}

