/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker;

import com.igormaznitsa.meta.checker.jversion.JavaVersion;
import com.igormaznitsa.meta.checker.jversion.LongComparator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.springframework.util.AntPathMatcher;

@Mojo(name="check-jar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class JarCheckerMojo
extends AbstractMojo {
    @Parameter(name="restrictClassFormat")
    private String restrictClassFormat;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="archive")
    private String archive;
    @Parameter(name="exclude")
    private List<String> exclude = new ArrayList<String>();
    @Parameter(name="include")
    private List<String> include = new ArrayList<String>();
    @Parameter(name="expected")
    private List<String> expected = new ArrayList<String>();
    @Parameter(name="unexpected")
    private List<String> unexpected = new ArrayList<String>();
    @Parameter(name="manifestHas")
    private List<String> manifestHas = new ArrayList<String>();
    @Parameter(name="manifestHasNot")
    private List<String> manifestHasNot = new ArrayList<String>();

    public String getRestrictClassFormat() {
        return this.restrictClassFormat;
    }

    public String getArchive() {
        return this.archive;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExpected() {
        return this.expected;
    }

    public List<String> getUnexpected() {
        return this.unexpected;
    }

    public List<String> getManifestHas() {
        return this.manifestHas;
    }

    public List<String> getManifestHasNot() {
        return this.manifestHasNot;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        JavaVersion javaVersion;
        LongComparator javaVersionComparator;
        JarFile jarFile;
        final Log log = this.getLog();
        File archiveFile = this.archive == null ? this.project.getArtifact().getFile() : new File(this.archive);
        if (!archiveFile.isFile()) {
            throw new MojoExecutionException("Can't find archive file: " + archiveFile);
        }
        log.info((CharSequence)("Check archive: " + archiveFile));
        try {
            jarFile = new JarFile(archiveFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Can't open archive file: " + archiveFile, (Exception)ex);
        }
        AtomicInteger classCounter = new AtomicInteger();
        if (this.restrictClassFormat != null) {
            int versionOffset;
            String javaClassVersion = this.restrictClassFormat.trim();
            if (javaClassVersion.isEmpty()) {
                throw new IllegalArgumentException("Detected empty value for 'restrictClassFormat'");
            }
            javaVersionComparator = LongComparator.find(javaClassVersion);
            if (javaVersionComparator == null) {
                if (Character.isDigit(javaClassVersion.charAt(0))) {
                    javaVersionComparator = LongComparator.EQU;
                }
                versionOffset = 0;
            } else {
                versionOffset = javaVersionComparator.getText().length();
            }
            javaClassVersion = javaClassVersion.substring(versionOffset).trim();
            javaVersion = JavaVersion.decode(javaClassVersion);
            if (javaVersion == null) {
                throw new IllegalArgumentException("Illegal java version in 'restrictClassFormat': " + javaClassVersion);
            }
            log.info((CharSequence)("Class version restriction: " + javaVersionComparator.getText() + ' ' + javaVersion.getText()));
        } else {
            javaVersionComparator = null;
            javaVersion = null;
        }
        final LongComparator finalJavaVersionComparator = javaVersionComparator;
        final AtomicInteger errorCounter = new AtomicInteger();
        int MAX_SHOWN_ERRORS = 48;
        if (!this.manifestHas.isEmpty() || !this.manifestHasNot.isEmpty()) {
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    log.error((CharSequence)"Java can't find MANIFEST.MF in the archive");
                    errorCounter.incrementAndGet();
                } else {
                    Attributes.Name keyName;
                    log.warn((CharSequence)(manifest.getEntries() + "  " + manifest.getMainAttributes().keySet()));
                    for (String key : this.manifestHas) {
                        keyName = new Attributes.Name(key);
                        if (manifest.getAttributes(key) != null || manifest.getMainAttributes().containsKey(keyName)) continue;
                        log.error((CharSequence)("Can't find key '" + key + "' in MANIFEST.MF"));
                        errorCounter.incrementAndGet();
                    }
                    for (String key : this.manifestHasNot) {
                        keyName = new Attributes.Name(key);
                        if (manifest.getAttributes(key) == null && !manifest.getMainAttributes().containsKey(keyName)) continue;
                        log.error((CharSequence)("Detected key '" + key + "' in MANIFEST.MF"));
                        errorCounter.incrementAndGet();
                    }
                }
            }
            catch (IOException ex) {
                log.error((CharSequence)"Can't read manifest file from the archive", (Throwable)ex);
                errorCounter.incrementAndGet();
            }
        }
        ClassVisitor classVisitor = new ClassVisitor(458752){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (finalJavaVersionComparator != null && !finalJavaVersionComparator.compare(version & 0xFFFF, javaVersion.getValue())) {
                    int errorNum = errorCounter.getAndIncrement();
                    if (errorNum < 48) {
                        JavaVersion classVersion = JavaVersion.decode(version & 0xFFFF);
                        log.error((CharSequence)("Detected illegal class version " + (classVersion == null ? "UNKNOWN" : classVersion.getText()) + " : " + name));
                    } else if (errorNum == 48) {
                        log.error((CharSequence)"...");
                    }
                }
            }
        };
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        Enumeration<JarEntry> entries = jarFile.entries();
        ArrayList<String> resourcesExpected = new ArrayList<String>(this.expected);
        ArrayList<String> resourcesUnexpected = new ArrayList<String>(this.unexpected);
        ArrayList<Iterator<String>> detectedUnexpectedPattern = new ArrayList<Iterator<String>>();
        while (entries.hasMoreElements() && !Thread.currentThread().isInterrupted()) {
            Object pattern;
            Iterator iter;
            JarEntry entry = entries.nextElement();
            String string = entry.getName();
            if (!resourcesExpected.isEmpty()) {
                iter = resourcesExpected.iterator();
                while (iter.hasNext()) {
                    pattern = (String)iter.next();
                    if (!antPathMatcher.match((String)pattern, string)) continue;
                    log.info((CharSequence)("Contains " + string + " (pattern: " + pattern + ")"));
                    iter.remove();
                }
            }
            if (!resourcesUnexpected.isEmpty()) {
                iter = resourcesUnexpected.iterator();
                while (iter.hasNext()) {
                    pattern = (String)iter.next();
                    if (!antPathMatcher.match((String)pattern, string)) continue;
                    detectedUnexpectedPattern.add((Iterator<String>)pattern);
                    log.error((CharSequence)("Detected unexpected " + string + " (pattern: " + pattern + ")"));
                    iter.remove();
                    errorCounter.incrementAndGet();
                }
            }
            boolean process = true;
            if (!this.include.isEmpty()) {
                process = false;
                for (String s : this.include) {
                    if (!antPathMatcher.match(s, string)) continue;
                    log.debug((CharSequence)(string + " included by pattern " + s));
                    process = true;
                    break;
                }
            }
            if (process) {
                for (String s : this.exclude) {
                    if (!antPathMatcher.match(s, string)) continue;
                    log.debug((CharSequence)(string + " excluded by pattern " + s));
                    process = false;
                    break;
                }
            }
            if (!process || entry.isDirectory() || !entry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) continue;
            classCounter.incrementAndGet();
            try {
                new ClassReader(IOUtils.readFully((InputStream)jarFile.getInputStream(entry), (int)((int)entry.getSize()))).accept(classVisitor, 7);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't parse JAR item: " + entry.getName(), (Exception)ex);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            log.warn((CharSequence)"Interrupted...");
            return;
        }
        if (!resourcesExpected.isEmpty()) {
            for (String string : resourcesExpected) {
                log.error((CharSequence)("Can't find resource for pattern: " + string));
                errorCounter.incrementAndGet();
            }
        }
        if (!detectedUnexpectedPattern.isEmpty()) {
            for (String string : detectedUnexpectedPattern) {
                log.error((CharSequence)("Detected unexpected resource for pattern: " + string));
            }
        }
        log.info((CharSequence)("Processed " + classCounter.get() + " class(es)"));
        if (errorCounter.get() != 0) {
            throw new MojoFailureException("Detected " + errorCounter.get() + " error(s)");
        }
    }
}

