/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public abstract class Utils {
    private static final PeriodFormatter TIME_FORMATTER = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().appendSeparator(".").minimumPrintedDigits(3).appendMillis().toFormatter();

    public static String extractClassName(String className) {
        if (className == null) {
            return null;
        }
        String normalized = className.indexOf(47) >= 0 ? Utils.classNameToNormalView(className) : className;
        return Utils.extractShortNameOfClass(normalized);
    }

    private Utils() {
    }

    public static String printTimeDelay(long timeInMilliseconds) {
        Duration duration = new Duration(timeInMilliseconds);
        Period period = duration.toPeriod().normalizedStandard(PeriodType.time());
        return TIME_FORMATTER.print((ReadablePeriod)period);
    }

    public static String extractShortNameOfClass(String canonicalClassName) {
        int index = canonicalClassName.lastIndexOf(46);
        String text = index < 0 ? canonicalClassName : canonicalClassName.substring(index + 1);
        index = text.lastIndexOf(36);
        text = index < 0 ? text : text.substring(index);
        return text;
    }

    public static String classNameToNormalView(String className) {
        if (className.startsWith("L") && className.endsWith(";")) {
            return className.substring(1, className.length() - 1).replace('/', '.');
        }
        return className;
    }

    public static String makeSignatureForClass(Class<?> klazz) {
        return Utils.makeSignatureForClass(klazz.getName());
    }

    public static String makeSignatureForClass(String name) {
        return 'L' + name.replace('.', '/') + ';';
    }

    public static String makeStr(int len, char ch) {
        StringBuilder result = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public static String normalizeClassNameAndRemoveSubclassName(String canonicalClassName) {
        String result = canonicalClassName.replace('.', '/');
        int index = result.lastIndexOf(36);
        result = index >= 0 ? result.substring(0, index) : result;
        return result;
    }

    public static String extractOuterClassName(String jvmInnerClassName) {
        int lastDelimiter = jvmInnerClassName.lastIndexOf(36);
        String result = "";
        if (lastDelimiter >= 0) {
            result = jvmInnerClassName.substring(0, lastDelimiter).replace('.', '/');
        }
        return result;
    }

    public static String asString(JavaClass clazz, FieldOrMethod item) {
        StringBuilder result = new StringBuilder();
        if (item != null) {
            if (item instanceof Field) {
                Field field = (Field)item;
                String type = Utility.signatureToString((String)field.getSignature());
                String name = field.getName();
                result.append(type).append(' ').append(name);
            } else {
                Method method = (Method)item;
                String type = Utility.methodSignatureReturnType((String)method.getSignature());
                String name = method.getName();
                if (name.equals("<init>")) {
                    name = Utils.extractClassName(clazz.getClassName());
                    type = "";
                } else {
                    type = type + ' ';
                }
                String[] args = Utility.methodSignatureArgumentTypes((String)method.getSignature());
                LocalVariableTable locVars = method.getLocalVariableTable();
                result.append(type).append(name).append('(');
                int locVarOffset = method.isStatic() ? 0 : 1;
                int index = 0;
                for (String a : args) {
                    if (index > 0) {
                        result.append(',');
                    }
                    result.append(a);
                    int argIndex = locVarOffset + index;
                    if (locVars != null && argIndex < locVars.getTableLength()) {
                        String argName;
                        LocalVariable localVariable = locVars.getLocalVariable(argIndex, 0);
                        String string = argName = localVariable == null ? "<unknown>" : localVariable.getName();
                        if (argName != null) {
                            result.append(' ').append(argName);
                        }
                    }
                    ++index;
                }
                result.append(')');
            }
        }
        return result.toString();
    }

    public static int findLineNumber(FieldOrMethod fieldOrMethod) {
        Method method;
        LineNumberTable lineTable;
        int result = -1;
        if (fieldOrMethod != null && fieldOrMethod instanceof Method && (lineTable = (method = (Method)fieldOrMethod).getLineNumberTable()) != null && lineTable.getTableLength() > 0 && (result = lineTable.getLineNumberTable()[0].getLineNumber()) > 1) {
            --result;
        }
        return result;
    }

    public static List<String> splitToLines(String str) {
        if (str == null || str.length() == 0) {
            return Collections.emptyList();
        }
        String[] strarray = str.split("\\n");
        for (int i = 0; i < strarray.length; ++i) {
            strarray[i] = strarray[i].replace("\t", "    ");
        }
        return Arrays.asList(strarray);
    }

    public static String escapeRegexToWildCat(String text) {
        StringBuilder result = new StringBuilder(text.length() * 3);
        result.append('^');
        block5: for (char c : text.toCharArray()) {
            switch (c) {
                case ' ': {
                    result.append("\\s");
                    continue block5;
                }
                case '*': {
                    result.append(".*?");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                default: {
                    result.append(Utils.utfCode(c));
                }
            }
        }
        result.append('$');
        return result.toString();
    }

    public static boolean isObjectType(Type type) {
        String text = type.getSignature();
        return text.endsWith(";");
    }

    private static String utfCode(char ch) {
        String s = Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
        return "\\u" + "0000".substring(0, 4 - s.length()) + s;
    }
}

