/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.extracheck;

import com.igormaznitsa.meta.annotation.MayContainNull;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.Utils;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.generic.Type;

public final class MethodParameterChecker {
    private static final Class<?>[] CLASSES_WHERE_POSSIBLE_NULL = new Class[]{List.class, Vector.class, Queue.class};
    private static final Set<String> CACHED_CLASS_NAMES_POSITIVE_RECOGNIZED = new HashSet<String>();
    private static final Set<String> CACHED_CLASS_NAMES_NEGATIVE_RECOGNIZED = new HashSet<String>();
    private static final Set<String> ANNOTATIONS_FOR_OBJECT = MethodParameterChecker.classesToNameSet(Nullable.class, Nonnull.class, "org.jetbrains.annotations.Nullable", "org.jetbrains.annotations.NotNull");
    private static final Set<String> ANNOTATIONS_FOR_ARRAY_OR_COLLECTION = MethodParameterChecker.classesToNameSet(MayContainNull.class, MustNotContainNull.class);
    private static final String RETURN_TYPE_NOTIFICATION = "Return type must be marked by either @%s or @%s";
    private static final String RETURN_TYPE_NOTIFICATION_WRONG_TYPE = "Non-object result type can't be marked by either @%s or @%s";
    private static final String ARG_TYPE_NOTIFICATION = "Arg. #%d must be marked by either @%s or @%s";

    public static void checkReturnTypeForNullable(Context context, Method method) {
        Type returnType = method.getReturnType();
        AnnotationEntry[] annotations = method.getAnnotationEntries();
        if (MethodParameterChecker.isNullableType(returnType)) {
            if (!MethodParameterChecker.hasAnnotationFromSet(annotations, ANNOTATIONS_FOR_OBJECT)) {
                context.error(String.format(RETURN_TYPE_NOTIFICATION, Utils.extractClassName(Nullable.class.getName()), Utils.extractClassName(Nonnull.class.getName())), true);
            }
        } else if (MethodParameterChecker.hasAnnotationFromSet(annotations, ANNOTATIONS_FOR_OBJECT)) {
            context.error(String.format(RETURN_TYPE_NOTIFICATION_WRONG_TYPE, Utils.extractClassName(Nullable.class.getName()), Utils.extractClassName(Nonnull.class.getName())), true);
        }
    }

    public static void checkReturnTypeForMayContainNull(Context context, Method method) {
        Type returnType = method.getReturnType();
        if (MethodParameterChecker.isNullableType(returnType)) {
            AnnotationEntry[] annotations = method.getAnnotationEntries();
            if (MethodParameterChecker.isArrayOfObjectsOrCollection(context, returnType) && !MethodParameterChecker.hasAnnotationFromSet(annotations, ANNOTATIONS_FOR_ARRAY_OR_COLLECTION)) {
                context.error(String.format(RETURN_TYPE_NOTIFICATION, Utils.extractClassName(MayContainNull.class.getName()), Utils.extractClassName(MustNotContainNull.class.getName())), true);
            }
        }
    }

    private static boolean shouldSkipFirstMethodArg(JavaClass klazz, Method method) {
        if (klazz.isNested() && "<init>".equals(method.getName()) && method.getArgumentTypes().length > 0) {
            if (klazz.isStatic()) {
                return false;
            }
            String firstArgType = method.getArgumentTypes()[0].getSignature();
            String outerKlazzSignature = 'L' + Utils.extractOuterClassName(klazz.getClassName()) + ';';
            return firstArgType.equals(outerKlazzSignature);
        }
        return method.getName().equals("<init>") && klazz.isNested() && !klazz.isStatic();
    }

    public static void checkParamsTypeForNullable(Context context, Method method) {
        Type[] arguments = method.getArgumentTypes();
        ParameterAnnotationEntry[] paramAnnotations = method.getParameterAnnotationEntries();
        boolean ignoreFirst = MethodParameterChecker.shouldSkipFirstMethodArg(context.getProcessingClass(), method);
        int argLength = arguments.length;
        int realArgLength = ignoreFirst ? argLength - 1 : argLength;
        int paramAnnoIndex = 0;
        for (int argIndex = 0; argIndex < argLength; ++argIndex) {
            if (ignoreFirst && argIndex == 0) continue;
            if (MethodParameterChecker.isNullableType(arguments[argIndex]) && (paramAnnoIndex >= paramAnnotations.length || !MethodParameterChecker.hasParameterAnnotationFromSet(realArgLength, paramAnnoIndex, paramAnnotations, ANNOTATIONS_FOR_OBJECT))) {
                context.error(String.format(ARG_TYPE_NOTIFICATION, argIndex + 1, Utils.extractClassName(Nullable.class.getName()), Utils.extractClassName(Nonnull.class.getName())), true);
            }
            ++paramAnnoIndex;
        }
    }

    public static void checkParamsTypeForMayContainNull(Context context, Method method) {
        Type[] arguments = method.getArgumentTypes();
        ParameterAnnotationEntry[] paramAnnotations = method.getParameterAnnotationEntries();
        boolean ignoreFirst = MethodParameterChecker.shouldSkipFirstMethodArg(context.getProcessingClass(), method);
        int argLength = arguments.length;
        int realArgLength = ignoreFirst ? argLength - 1 : argLength;
        int paramAnnoIndex = 0;
        for (int argIndex = 0; argIndex < argLength; ++argIndex) {
            if (ignoreFirst && argIndex == 0) continue;
            if (MethodParameterChecker.isNullableType(arguments[argIndex]) && MethodParameterChecker.isArrayOfObjectsOrCollection(context, arguments[argIndex]) && (paramAnnoIndex >= paramAnnotations.length || !MethodParameterChecker.hasParameterAnnotationFromSet(realArgLength, paramAnnoIndex, paramAnnotations, ANNOTATIONS_FOR_ARRAY_OR_COLLECTION))) {
                context.error(String.format(ARG_TYPE_NOTIFICATION, argIndex + 1, Utils.extractClassName(MayContainNull.class.getName()), Utils.extractClassName(MustNotContainNull.class.getName())), true);
            }
            ++paramAnnoIndex;
        }
    }

    private static Set<String> classesToNameSet(Object ... klazzes) {
        HashSet<String> result = new HashSet<String>();
        for (Object k : klazzes) {
            if (k instanceof Class) {
                result.add(Utils.makeSignatureForClass((Class)k));
                continue;
            }
            if (k instanceof String) {
                result.add(Utils.makeSignatureForClass((String)k));
                continue;
            }
            throw Assertions.fail((String)("Unexpected object type [" + k + ']'));
        }
        return result;
    }

    private static boolean isNullableType(Type type) {
        String signature = type.getSignature();
        return signature.length() > 0 && (signature.charAt(0) == '[' || signature.charAt(0) == 'L');
    }

    private static boolean isArrayOfObjectsOrCollection(Context context, Type type) {
        String signature = type.getSignature();
        int arrayLastChar = signature.lastIndexOf(91);
        if (arrayLastChar > 0) {
            return true;
        }
        if (signature.endsWith(";")) {
            if (arrayLastChar >= 0) {
                return true;
            }
        } else {
            return false;
        }
        if (CACHED_CLASS_NAMES_POSITIVE_RECOGNIZED.contains(signature)) {
            return true;
        }
        if (CACHED_CLASS_NAMES_NEGATIVE_RECOGNIZED.contains(signature)) {
            return false;
        }
        return MethodParameterChecker.investigateClassThatCanContainNull(context, signature);
    }

    private static boolean investigateClassThatCanContainNull(Context context, String classTypeInInsideFormat) {
        String klazzName = Utils.classNameToNormalView(classTypeInInsideFormat);
        File classFile = new File(context.getTargetDirectoryFolder(), klazzName.replace('.', '/') + ".class");
        if (classFile.isFile()) {
            try {
                String superClassInInsideFormat;
                JavaClass jclazz = new ClassParser(classFile.getAbsolutePath()).parse();
                for (String interfaceName : jclazz.getInterfaceNames()) {
                    if (!MethodParameterChecker.investigateClassThatCanContainNull(context, Utils.makeSignatureForClass(interfaceName))) continue;
                    CACHED_CLASS_NAMES_POSITIVE_RECOGNIZED.add(classTypeInInsideFormat);
                    return true;
                }
                String superclassName = jclazz.getSuperclassName();
                if (superclassName != null && !superclassName.equals("java.lang.Object") && MethodParameterChecker.investigateClassThatCanContainNull(context, superClassInInsideFormat = Utils.makeSignatureForClass(superclassName))) {
                    CACHED_CLASS_NAMES_POSITIVE_RECOGNIZED.add(classTypeInInsideFormat);
                    return true;
                }
            }
            catch (Exception ex) {
                context.warning("Can't parse class file : " + classFile.getAbsolutePath(), false);
            }
        } else {
            String normalClassName = klazzName.replace('$', '.');
            try {
                Class<?> klazz = Class.forName(normalClassName);
                for (Class<?> klazzWherePossibleNull : CLASSES_WHERE_POSSIBLE_NULL) {
                    if (!klazzWherePossibleNull.isAssignableFrom(klazz)) continue;
                    CACHED_CLASS_NAMES_POSITIVE_RECOGNIZED.add(classTypeInInsideFormat);
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        CACHED_CLASS_NAMES_NEGATIVE_RECOGNIZED.add(classTypeInInsideFormat);
        return false;
    }

    private static boolean hasAnnotationFromSet(AnnotationEntry[] annotations, Set<String> namesToFind) {
        for (AnnotationEntry a : annotations) {
            if (!namesToFind.contains(a.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasParameterAnnotationFromSet(int numberOfArguments, int indexInParamAnnotations, ParameterAnnotationEntry[] paramAnnotations, Set<String> namesToFind) {
        while (indexInParamAnnotations < paramAnnotations.length) {
            for (AnnotationEntry a : paramAnnotations[indexInParamAnnotations].getAnnotationEntries()) {
                if (!namesToFind.contains(a.getAnnotationType())) continue;
                return true;
            }
            indexInParamAnnotations += numberOfArguments;
        }
        return false;
    }
}

