/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.jversion;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum JavaVersion {
    JDK11("1.1", 45),
    JDK12("1.2", 46),
    JDK13("1.3", 47),
    JDK14("1.4", 48),
    JDK50("5.0", 49),
    JDK60("6.0", 50),
    JDK70("7.0", 51),
    JDK80("8.0", 52),
    JDK90("9.0", 53),
    JDK100("10.0", 54),
    JDK110("11.0", 55);

    private final String text;
    private final int value;

    private JavaVersion(String text, int value) {
        this.text = text;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    @Nullable
    public static JavaVersion decode(@Nonnull String text) {
        String trimmed = text.trim();
        if (trimmed.indexOf(46) < 0) {
            trimmed = trimmed + ".0";
        }
        for (JavaVersion v : JavaVersion.values()) {
            if (!v.text.equals(trimmed)) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static JavaVersion decode(int major) {
        for (JavaVersion v : JavaVersion.values()) {
            if (major != v.getValue()) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.text;
    }
}

