/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.jversion;

import com.igormaznitsa.meta.checker.jversion.comparators.AbstractCompareLongAction;
import com.igormaznitsa.meta.checker.jversion.comparators.ComparatorLongEQU;
import com.igormaznitsa.meta.checker.jversion.comparators.ComparatorLongEQUGT;
import com.igormaznitsa.meta.checker.jversion.comparators.ComparatorLongEQULESS;
import com.igormaznitsa.meta.checker.jversion.comparators.ComparatorLongGT;
import com.igormaznitsa.meta.checker.jversion.comparators.ComparatorLongLESS;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum LongComparator {
    LESSEQU("<=", new ComparatorLongEQULESS()),
    GTEQU(">=", new ComparatorLongEQUGT()),
    EQU("=", new ComparatorLongEQU()),
    LESS("<", new ComparatorLongLESS()),
    GT(">", new ComparatorLongGT());

    private final String text;
    private final AbstractCompareLongAction action;

    private LongComparator(String text, AbstractCompareLongAction action) {
        this.text = text;
        this.action = action;
    }

    public String getText() {
        return this.text;
    }

    public boolean compare(long value1, long value2) {
        return this.action.compare(value1, value2);
    }

    @Nullable
    public static LongComparator find(@Nonnull String text) {
        String trimmed = text;
        for (LongComparator op : LongComparator.values()) {
            if (!trimmed.startsWith(op.text)) continue;
            return op;
        }
        return null;
    }
}

