/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.processors;

import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.Utils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;

public abstract class AbstractMetaAnnotationProcessor {
    private final Set<ElementType> ALLOWED_ELEMENTS = EnumSet.noneOf(ElementType.class);
    private final String ANNOTATION_TYPE;
    private final boolean alertable;

    public AbstractMetaAnnotationProcessor() {
        Class<? extends Annotation> theKlazz = this.getAnnotationClass();
        this.ANNOTATION_TYPE = Utils.makeSignatureForClass(theKlazz);
        for (ElementType t : theKlazz.getAnnotation(Target.class).value()) {
            this.ALLOWED_ELEMENTS.add(t);
        }
        boolean hasAlertField = false;
        try {
            java.lang.reflect.Method alert = theKlazz.getMethod("alert", new Class[0]);
            hasAlertField = alert.getReturnType() == Boolean.TYPE;
        }
        catch (NoSuchMethodException alert) {
        }
        catch (SecurityException ex) {
            throw new Error("Unexpected security error", ex);
        }
        this.alertable = hasAlertField;
    }

    public boolean isAlertable() {
        return this.alertable;
    }

    public final boolean isElementTypeAllowed(ElementType type) {
        return this.ALLOWED_ELEMENTS.contains((Object)type);
    }

    public final void processClass(Context context, JavaClass clazz, int itemIndex) {
        context.setProcessingItem(clazz, null, itemIndex);
        if (this.isElementTypeAllowed(ElementType.TYPE)) {
            this.processType(context, clazz, clazz.getAnnotationEntries());
        }
        context.setProcessingItem(clazz, null, itemIndex);
        if (this.isElementTypeAllowed(ElementType.FIELD)) {
            this.processFields(context, clazz, clazz.getFields());
        }
        context.setProcessingItem(clazz, null, itemIndex);
        if (this.isElementTypeAllowed(ElementType.METHOD) || this.isElementTypeAllowed(ElementType.PARAMETER)) {
            this.processMethods(context, clazz, clazz.getMethods());
        }
        context.setProcessingItem(clazz, null, itemIndex);
    }

    private void processType(Context context, JavaClass clazz, AnnotationEntry[] annotations) {
        for (AnnotationEntry ae : annotations) {
            if (!this.ANNOTATION_TYPE.equals(ae.getAnnotationType())) continue;
            this.process(context, clazz, ElementType.TYPE, null, ae);
        }
    }

    private void processFields(Context context, JavaClass clazz, Field[] fields) {
        int index = 0;
        for (Field f : fields) {
            context.setProcessingItem(clazz, (FieldOrMethod)f, index++);
            for (AnnotationEntry ae : f.getAnnotationEntries()) {
                if (!this.ANNOTATION_TYPE.equals(ae.getAnnotationType())) continue;
                this.process(context, clazz, ElementType.FIELD, null, ae);
            }
        }
    }

    private void processMethods(Context context, JavaClass clazz, Method[] methods) {
        int methodIndex = 0;
        for (Method m : methods) {
            int argNumner = m.getArgumentTypes().length;
            if (this.isElementTypeAllowed(ElementType.METHOD)) {
                for (AnnotationEntry ae : m.getAnnotationEntries()) {
                    context.setProcessingItem(clazz, (FieldOrMethod)m, methodIndex);
                    if (!this.ANNOTATION_TYPE.equals(ae.getAnnotationType())) continue;
                    this.process(context, clazz, ElementType.METHOD, null, ae);
                }
            }
            if (this.isElementTypeAllowed(ElementType.PARAMETER)) {
                int paramIndex = 0;
                for (ParameterAnnotationEntry pe : m.getParameterAnnotationEntries()) {
                    context.setProcessingItem(clazz, (FieldOrMethod)m, paramIndex++ % argNumner);
                    for (AnnotationEntry ae : pe.getAnnotationEntries()) {
                        if (!this.ANNOTATION_TYPE.equals(ae.getAnnotationType())) continue;
                        this.process(context, clazz, ElementType.PARAMETER, pe, ae);
                    }
                }
            }
            ++methodIndex;
        }
    }

    protected static String extractStrValue(String field, AnnotationEntry entry, String dflt) {
        ElementValue value = AbstractMetaAnnotationProcessor.extractValue(field, entry);
        return value == null ? dflt : value.stringifyValue();
    }

    protected static ElementValue extractValue(String field, AnnotationEntry entry) {
        ElementValue result = null;
        for (ElementValuePair p : entry.getElementValuePairs()) {
            if (!field.equals(p.getNameString())) continue;
            result = p.getValue();
            break;
        }
        return result;
    }

    protected static Map<String, ElementValue> parseValues(AnnotationEntry entry) {
        HashMap<String, ElementValue> result = new HashMap<String, ElementValue>();
        for (ElementValuePair p : entry.getElementValuePairs()) {
            result.put(p.getNameString(), p.getValue());
        }
        return result;
    }

    private void process(Context context, JavaClass clazz, ElementType type, ParameterAnnotationEntry pae, AnnotationEntry ae) {
        this.doProcessing(context, clazz, type, pae, ae);
    }

    protected static String addSemicolonIfNeeded(String text) {
        return text == null ? text : (text.isEmpty() ? text : " : " + text);
    }

    protected abstract void doProcessing(Context var1, JavaClass var2, ElementType var3, ParameterAnnotationEntry var4, AnnotationEntry var5);

    public abstract Class<? extends Annotation> getAnnotationClass();
}

